// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/internal/translation_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/translate/v3/translation_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace translate_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TranslationServiceMetadata::TranslationServiceMetadata(
    std::shared_ptr<TranslationServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceMetadata::TranslateText(
    grpc::ClientContext& context,
    google::cloud::translation::v3::TranslateTextRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->TranslateText(context, request);
}

StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
TranslationServiceMetadata::DetectLanguage(
    grpc::ClientContext& context,
    google::cloud::translation::v3::DetectLanguageRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->DetectLanguage(context, request);
}

StatusOr<google::cloud::translation::v3::SupportedLanguages>
TranslationServiceMetadata::GetSupportedLanguages(
    grpc::ClientContext& context,
    google::cloud::translation::v3::GetSupportedLanguagesRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->GetSupportedLanguages(context, request);
}

StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
TranslationServiceMetadata::TranslateDocument(
    grpc::ClientContext& context,
    google::cloud::translation::v3::TranslateDocumentRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->TranslateDocument(context, request);
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceMetadata::AsyncBatchTranslateText(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::translation::v3::BatchTranslateTextRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncBatchTranslateText(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceMetadata::AsyncBatchTranslateDocument(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncBatchTranslateDocument(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceMetadata::AsyncCreateGlossary(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::translation::v3::CreateGlossaryRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateGlossary(cq, std::move(context), request);
}

StatusOr<google::cloud::translation::v3::ListGlossariesResponse>
TranslationServiceMetadata::ListGlossaries(
    grpc::ClientContext& context,
    google::cloud::translation::v3::ListGlossariesRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListGlossaries(context, request);
}

StatusOr<google::cloud::translation::v3::Glossary>
TranslationServiceMetadata::GetGlossary(
    grpc::ClientContext& context,
    google::cloud::translation::v3::GetGlossaryRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetGlossary(context, request);
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceMetadata::AsyncDeleteGlossary(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::translation::v3::DeleteGlossaryRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteGlossary(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
TranslationServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> TranslationServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void TranslationServiceMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void TranslationServiceMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_internal
}  // namespace cloud
}  // namespace google
