// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v2/tracing.proto

#include "google/cloud/trace/trace_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace trace {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TraceServiceConnectionIdempotencyPolicy::
    ~TraceServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultTraceServiceConnectionIdempotencyPolicy
    : public TraceServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultTraceServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<TraceServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultTraceServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency BatchWriteSpans(
      google::devtools::cloudtrace::v2::BatchWriteSpansRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateSpan(
      google::devtools::cloudtrace::v2::Span const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<TraceServiceConnectionIdempotencyPolicy>
MakeDefaultTraceServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultTraceServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace
}  // namespace cloud
}  // namespace google
