// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v2/tracing.proto

#include "google/cloud/trace/trace_connection.h"
#include "google/cloud/trace/internal/trace_connection_impl.h"
#include "google/cloud/trace/internal/trace_option_defaults.h"
#include "google/cloud/trace/internal/trace_stub_factory.h"
#include "google/cloud/trace/trace_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace trace {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TraceServiceConnection::~TraceServiceConnection() = default;

Status TraceServiceConnection::BatchWriteSpans(
    google::devtools::cloudtrace::v2::BatchWriteSpansRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::cloudtrace::v2::Span>
TraceServiceConnection::CreateSpan(
    google::devtools::cloudtrace::v2::Span const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<TraceServiceConnection> MakeTraceServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 TraceServicePolicyOptionList>(options,
                                                               __func__);
  options = trace_internal::TraceServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      trace_internal::CreateDefaultTraceServiceStub(background->cq(), options);
  return std::make_shared<trace_internal::TraceServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace trace_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<trace::TraceServiceConnection> MakeTraceServiceConnection(
    std::shared_ptr<TraceServiceStub> stub, Options options) {
  options = TraceServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<trace_internal::TraceServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_internal
}  // namespace cloud
}  // namespace google
