// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v1/cloud_tpu.proto

#include "google/cloud/tpu/tpu_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace tpu {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TpuConnectionIdempotencyPolicy::~TpuConnectionIdempotencyPolicy() = default;

namespace {
class DefaultTpuConnectionIdempotencyPolicy
    : public TpuConnectionIdempotencyPolicy {
 public:
  ~DefaultTpuConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<TpuConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultTpuConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListNodes(google::cloud::tpu::v1::ListNodesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetNode(google::cloud::tpu::v1::GetNodeRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateNode(
      google::cloud::tpu::v1::CreateNodeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteNode(
      google::cloud::tpu::v1::DeleteNodeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ReimageNode(
      google::cloud::tpu::v1::ReimageNodeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency StopNode(
      google::cloud::tpu::v1::StopNodeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency StartNode(
      google::cloud::tpu::v1::StartNodeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListTensorFlowVersions(
      google::cloud::tpu::v1::ListTensorFlowVersionsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetTensorFlowVersion(
      google::cloud::tpu::v1::GetTensorFlowVersionRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListAcceleratorTypes(
      google::cloud::tpu::v1::ListAcceleratorTypesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetAcceleratorType(
      google::cloud::tpu::v1::GetAcceleratorTypeRequest const&) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<TpuConnectionIdempotencyPolicy>
MakeDefaultTpuConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultTpuConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu
}  // namespace cloud
}  // namespace google
