// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v1/cloud_tpu.proto

#include "google/cloud/tpu/internal/tpu_auth_decorator.h"
#include <google/cloud/tpu/v1/cloud_tpu.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace tpu_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TpuAuth::TpuAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<TpuStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::tpu::v1::ListNodesResponse> TpuAuth::ListNodes(
    grpc::ClientContext& context,
    google::cloud::tpu::v1::ListNodesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListNodes(context, request);
}

StatusOr<google::cloud::tpu::v1::Node> TpuAuth::GetNode(
    grpc::ClientContext& context,
    google::cloud::tpu::v1::GetNodeRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetNode(context, request);
}

future<StatusOr<google::longrunning::Operation>> TpuAuth::AsyncCreateNode(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::tpu::v1::CreateNodeRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateNode(cq, *std::move(context), request);
      });
}

future<StatusOr<google::longrunning::Operation>> TpuAuth::AsyncDeleteNode(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::tpu::v1::DeleteNodeRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncDeleteNode(cq, *std::move(context), request);
      });
}

future<StatusOr<google::longrunning::Operation>> TpuAuth::AsyncReimageNode(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::tpu::v1::ReimageNodeRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncReimageNode(cq, *std::move(context), request);
      });
}

future<StatusOr<google::longrunning::Operation>> TpuAuth::AsyncStopNode(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::tpu::v1::StopNodeRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncStopNode(cq, *std::move(context), request);
      });
}

future<StatusOr<google::longrunning::Operation>> TpuAuth::AsyncStartNode(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::tpu::v1::StartNodeRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncStartNode(cq, *std::move(context), request);
      });
}

StatusOr<google::cloud::tpu::v1::ListTensorFlowVersionsResponse>
TpuAuth::ListTensorFlowVersions(
    grpc::ClientContext& context,
    google::cloud::tpu::v1::ListTensorFlowVersionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListTensorFlowVersions(context, request);
}

StatusOr<google::cloud::tpu::v1::TensorFlowVersion>
TpuAuth::GetTensorFlowVersion(
    grpc::ClientContext& context,
    google::cloud::tpu::v1::GetTensorFlowVersionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetTensorFlowVersion(context, request);
}

StatusOr<google::cloud::tpu::v1::ListAcceleratorTypesResponse>
TpuAuth::ListAcceleratorTypes(
    grpc::ClientContext& context,
    google::cloud::tpu::v1::ListAcceleratorTypesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListAcceleratorTypes(context, request);
}

StatusOr<google::cloud::tpu::v1::AcceleratorType> TpuAuth::GetAcceleratorType(
    grpc::ClientContext& context,
    google::cloud::tpu::v1::GetAcceleratorTypeRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetAcceleratorType(context, request);
}

future<StatusOr<google::longrunning::Operation>> TpuAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context), request);
      });
}

future<Status> TpuAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu_internal
}  // namespace cloud
}  // namespace google
