// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/texttospeech/v1/cloud_tts.proto

#include "google/cloud/texttospeech/text_to_speech_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace texttospeech {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TextToSpeechConnectionIdempotencyPolicy::
    ~TextToSpeechConnectionIdempotencyPolicy() = default;

namespace {
class DefaultTextToSpeechConnectionIdempotencyPolicy
    : public TextToSpeechConnectionIdempotencyPolicy {
 public:
  ~DefaultTextToSpeechConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<TextToSpeechConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultTextToSpeechConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListVoices(
      google::cloud::texttospeech::v1::ListVoicesRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency SynthesizeSpeech(
      google::cloud::texttospeech::v1::SynthesizeSpeechRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<TextToSpeechConnectionIdempotencyPolicy>
MakeDefaultTextToSpeechConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultTextToSpeechConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace texttospeech
}  // namespace cloud
}  // namespace google
