// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/texttospeech/v1/cloud_tts.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TEXTTOSPEECH_TEXT_TO_SPEECH_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TEXTTOSPEECH_TEXT_TO_SPEECH_CLIENT_H

#include "google/cloud/texttospeech/text_to_speech_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace texttospeech {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service that implements Google Cloud Text-to-Speech API.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class TextToSpeechClient {
 public:
  explicit TextToSpeechClient(
      std::shared_ptr<TextToSpeechConnection> connection, Options options = {});
  ~TextToSpeechClient();

  //@{
  // @name Copy and move support
  TextToSpeechClient(TextToSpeechClient const&) = default;
  TextToSpeechClient& operator=(TextToSpeechClient const&) = default;
  TextToSpeechClient(TextToSpeechClient&&) = default;
  TextToSpeechClient& operator=(TextToSpeechClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(TextToSpeechClient const& a,
                         TextToSpeechClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TextToSpeechClient const& a,
                         TextToSpeechClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Returns a list of Voice supported for synthesis.
  ///
  /// @param language_code  Optional. Recommended.
  ///  [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. If
  ///  specified, the ListVoices call will only return voices that can be used
  ///  to synthesize this language_code. E.g. when specifying `"en-NZ"`, you
  ///  will get supported `"en-\*"` voices; when specifying `"no"`, you will get
  ///  supported
  ///  `"no-\*"` (Norwegian) and `"nb-\*"` (Norwegian Bokmal) voices; specifying
  ///  `"zh"` will also get supported `"cmn-\*"` voices; specifying `"zh-hk"`
  ///  will also get supported `"yue-\*"` voices.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::texttospeech::v1::ListVoicesResponse,google/cloud/texttospeech/v1/cloud_tts.proto#L123}
  ///
  /// [google.cloud.texttospeech.v1.ListVoicesRequest]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L62}
  /// [google.cloud.texttospeech.v1.ListVoicesResponse]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L123}
  ///
  StatusOr<google::cloud::texttospeech::v1::ListVoicesResponse> ListVoices(
      std::string const& language_code, Options options = {});

  ///
  /// Returns a list of Voice supported for synthesis.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::texttospeech::v1::ListVoicesRequest,google/cloud/texttospeech/v1/cloud_tts.proto#L62}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::texttospeech::v1::ListVoicesResponse,google/cloud/texttospeech/v1/cloud_tts.proto#L123}
  ///
  /// [google.cloud.texttospeech.v1.ListVoicesRequest]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L62}
  /// [google.cloud.texttospeech.v1.ListVoicesResponse]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L123}
  ///
  StatusOr<google::cloud::texttospeech::v1::ListVoicesResponse> ListVoices(
      google::cloud::texttospeech::v1::ListVoicesRequest const& request,
      Options options = {});

  ///
  /// Synthesizes speech synchronously: receive results after all text input
  /// has been processed.
  ///
  /// @param input  Required. The Synthesizer requires either plain text or SSML
  /// as input.
  /// @param voice  Required. The desired voice of the synthesized audio.
  /// @param audio_config  Required. The configuration of the synthesized audio.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::texttospeech::v1::SynthesizeSpeechResponse,google/cloud/texttospeech/v1/cloud_tts.proto#L259}
  ///
  /// [google.cloud.texttospeech.v1.SynthesizeSpeechRequest]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L146}
  /// [google.cloud.texttospeech.v1.SynthesizeSpeechResponse]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L259}
  ///
  StatusOr<google::cloud::texttospeech::v1::SynthesizeSpeechResponse>
  SynthesizeSpeech(
      google::cloud::texttospeech::v1::SynthesisInput const& input,
      google::cloud::texttospeech::v1::VoiceSelectionParams const& voice,
      google::cloud::texttospeech::v1::AudioConfig const& audio_config,
      Options options = {});

  ///
  /// Synthesizes speech synchronously: receive results after all text input
  /// has been processed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::texttospeech::v1::SynthesizeSpeechRequest,google/cloud/texttospeech/v1/cloud_tts.proto#L146}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::texttospeech::v1::SynthesizeSpeechResponse,google/cloud/texttospeech/v1/cloud_tts.proto#L259}
  ///
  /// [google.cloud.texttospeech.v1.SynthesizeSpeechRequest]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L146}
  /// [google.cloud.texttospeech.v1.SynthesizeSpeechResponse]:
  /// @googleapis_reference_link{google/cloud/texttospeech/v1/cloud_tts.proto#L259}
  ///
  StatusOr<google::cloud::texttospeech::v1::SynthesizeSpeechResponse>
  SynthesizeSpeech(
      google::cloud::texttospeech::v1::SynthesizeSpeechRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<TextToSpeechConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace texttospeech
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TEXTTOSPEECH_TEXT_TO_SPEECH_CLIENT_H
