// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/texttospeech/v1/cloud_tts.proto

#include "google/cloud/texttospeech/internal/text_to_speech_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/texttospeech/v1/cloud_tts.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace texttospeech_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TextToSpeechStub::~TextToSpeechStub() = default;

StatusOr<google::cloud::texttospeech::v1::ListVoicesResponse>
DefaultTextToSpeechStub::ListVoices(
    grpc::ClientContext& client_context,
    google::cloud::texttospeech::v1::ListVoicesRequest const& request) {
  google::cloud::texttospeech::v1::ListVoicesResponse response;
  auto status = grpc_stub_->ListVoices(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::texttospeech::v1::SynthesizeSpeechResponse>
DefaultTextToSpeechStub::SynthesizeSpeech(
    grpc::ClientContext& client_context,
    google::cloud::texttospeech::v1::SynthesizeSpeechRequest const& request) {
  google::cloud::texttospeech::v1::SynthesizeSpeechResponse response;
  auto status =
      grpc_stub_->SynthesizeSpeech(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace texttospeech_internal
}  // namespace cloud
}  // namespace google
