// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/texttospeech/v1/cloud_tts.proto

#include "google/cloud/texttospeech/internal/text_to_speech_connection_impl.h"
#include "google/cloud/texttospeech/internal/text_to_speech_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace texttospeech_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TextToSpeechConnectionImpl::TextToSpeechConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<texttospeech_internal::TextToSpeechStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), texttospeech_internal::TextToSpeechDefaultOptions(
                                  TextToSpeechConnection::options()))) {}

StatusOr<google::cloud::texttospeech::v1::ListVoicesResponse>
TextToSpeechConnectionImpl::ListVoices(
    google::cloud::texttospeech::v1::ListVoicesRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListVoices(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::texttospeech::v1::ListVoicesRequest const& request) {
        return stub_->ListVoices(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::texttospeech::v1::SynthesizeSpeechResponse>
TextToSpeechConnectionImpl::SynthesizeSpeech(
    google::cloud::texttospeech::v1::SynthesizeSpeechRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SynthesizeSpeech(request),
      [this](grpc::ClientContext& context,
             google::cloud::texttospeech::v1::SynthesizeSpeechRequest const&
                 request) { return stub_->SynthesizeSpeech(context, request); },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace texttospeech_internal
}  // namespace cloud
}  // namespace google
