// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tasks/v2/cloudtasks.proto

#include "google/cloud/tasks/internal/cloud_tasks_connection_impl.h"
#include "google/cloud/tasks/internal/cloud_tasks_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace tasks_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudTasksConnectionImpl::CloudTasksConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<tasks_internal::CloudTasksStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      tasks_internal::CloudTasksDefaultOptions(
                                          CloudTasksConnection::options()))) {}

StreamRange<google::cloud::tasks::v2::Queue>
CloudTasksConnectionImpl::ListQueues(
    google::cloud::tasks::v2::ListQueuesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<tasks::CloudTasksRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListQueues(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::tasks::v2::Queue>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::tasks::v2::ListQueuesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::tasks::v2::ListQueuesRequest const& request) {
              return stub->ListQueues(context, request);
            },
            r, function_name);
      },
      [](google::cloud::tasks::v2::ListQueuesResponse r) {
        std::vector<google::cloud::tasks::v2::Queue> result(r.queues().size());
        auto& messages = *r.mutable_queues();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnectionImpl::GetQueue(
    google::cloud::tasks::v2::GetQueueRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(), idempotency_policy()->GetQueue(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::GetQueueRequest const& request) {
        return stub_->GetQueue(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnectionImpl::CreateQueue(
    google::cloud::tasks::v2::CreateQueueRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateQueue(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::CreateQueueRequest const& request) {
        return stub_->CreateQueue(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnectionImpl::UpdateQueue(
    google::cloud::tasks::v2::UpdateQueueRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateQueue(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::UpdateQueueRequest const& request) {
        return stub_->UpdateQueue(context, request);
      },
      request, __func__);
}

Status CloudTasksConnectionImpl::DeleteQueue(
    google::cloud::tasks::v2::DeleteQueueRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteQueue(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::DeleteQueueRequest const& request) {
        return stub_->DeleteQueue(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnectionImpl::PurgeQueue(
    google::cloud::tasks::v2::PurgeQueueRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->PurgeQueue(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::PurgeQueueRequest const& request) {
        return stub_->PurgeQueue(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnectionImpl::PauseQueue(
    google::cloud::tasks::v2::PauseQueueRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->PauseQueue(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::PauseQueueRequest const& request) {
        return stub_->PauseQueue(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnectionImpl::ResumeQueue(
    google::cloud::tasks::v2::ResumeQueueRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ResumeQueue(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::ResumeQueueRequest const& request) {
        return stub_->ResumeQueue(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> CloudTasksConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> CloudTasksConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudTasksConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::tasks::v2::Task> CloudTasksConnectionImpl::ListTasks(
    google::cloud::tasks::v2::ListTasksRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<tasks::CloudTasksRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListTasks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::tasks::v2::Task>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::tasks::v2::ListTasksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::tasks::v2::ListTasksRequest const& request) {
              return stub->ListTasks(context, request);
            },
            r, function_name);
      },
      [](google::cloud::tasks::v2::ListTasksResponse r) {
        std::vector<google::cloud::tasks::v2::Task> result(r.tasks().size());
        auto& messages = *r.mutable_tasks();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksConnectionImpl::GetTask(
    google::cloud::tasks::v2::GetTaskRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(), idempotency_policy()->GetTask(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::GetTaskRequest const& request) {
        return stub_->GetTask(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksConnectionImpl::CreateTask(
    google::cloud::tasks::v2::CreateTaskRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateTask(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::CreateTaskRequest const& request) {
        return stub_->CreateTask(context, request);
      },
      request, __func__);
}

Status CloudTasksConnectionImpl::DeleteTask(
    google::cloud::tasks::v2::DeleteTaskRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteTask(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::DeleteTaskRequest const& request) {
        return stub_->DeleteTask(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksConnectionImpl::RunTask(
    google::cloud::tasks::v2::RunTaskRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(), idempotency_policy()->RunTask(request),
      [this](grpc::ClientContext& context,
             google::cloud::tasks::v2::RunTaskRequest const& request) {
        return stub_->RunTask(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks_internal
}  // namespace cloud
}  // namespace google
