// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tasks/v2/cloudtasks.proto

#include "google/cloud/tasks/cloud_tasks_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace tasks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudTasksConnectionIdempotencyPolicy::
    ~CloudTasksConnectionIdempotencyPolicy() = default;

namespace {
class DefaultCloudTasksConnectionIdempotencyPolicy
    : public CloudTasksConnectionIdempotencyPolicy {
 public:
  ~DefaultCloudTasksConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<CloudTasksConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultCloudTasksConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListQueues(google::cloud::tasks::v2::ListQueuesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetQueue(
      google::cloud::tasks::v2::GetQueueRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateQueue(
      google::cloud::tasks::v2::CreateQueueRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateQueue(
      google::cloud::tasks::v2::UpdateQueueRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteQueue(
      google::cloud::tasks::v2::DeleteQueueRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency PurgeQueue(
      google::cloud::tasks::v2::PurgeQueueRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency PauseQueue(
      google::cloud::tasks::v2::PauseQueueRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ResumeQueue(
      google::cloud::tasks::v2::ResumeQueueRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListTasks(google::cloud::tasks::v2::ListTasksRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetTask(
      google::cloud::tasks::v2::GetTaskRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateTask(
      google::cloud::tasks::v2::CreateTaskRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteTask(
      google::cloud::tasks::v2::DeleteTaskRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RunTask(
      google::cloud::tasks::v2::RunTaskRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<CloudTasksConnectionIdempotencyPolicy>
MakeDefaultCloudTasksConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultCloudTasksConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks
}  // namespace cloud
}  // namespace google
