// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tasks/v2/cloudtasks.proto

#include "google/cloud/tasks/cloud_tasks_connection.h"
#include "google/cloud/tasks/cloud_tasks_options.h"
#include "google/cloud/tasks/internal/cloud_tasks_connection_impl.h"
#include "google/cloud/tasks/internal/cloud_tasks_option_defaults.h"
#include "google/cloud/tasks/internal/cloud_tasks_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace tasks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudTasksConnection::~CloudTasksConnection() = default;

StreamRange<google::cloud::tasks::v2::Queue> CloudTasksConnection::ListQueues(
    google::cloud::tasks::v2::ListQueuesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::tasks::v2::Queue>>(
      std::move(request),
      [](google::cloud::tasks::v2::ListQueuesRequest const&) {
        return StatusOr<google::cloud::tasks::v2::ListQueuesResponse>{};
      },
      [](google::cloud::tasks::v2::ListQueuesResponse const&) {
        return std::vector<google::cloud::tasks::v2::Queue>();
      });
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnection::GetQueue(
    google::cloud::tasks::v2::GetQueueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnection::CreateQueue(
    google::cloud::tasks::v2::CreateQueueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnection::UpdateQueue(
    google::cloud::tasks::v2::UpdateQueueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status CloudTasksConnection::DeleteQueue(
    google::cloud::tasks::v2::DeleteQueueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnection::PurgeQueue(
    google::cloud::tasks::v2::PurgeQueueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnection::PauseQueue(
    google::cloud::tasks::v2::PauseQueueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksConnection::ResumeQueue(
    google::cloud::tasks::v2::ResumeQueueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudTasksConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudTasksConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudTasksConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::tasks::v2::Task> CloudTasksConnection::ListTasks(
    google::cloud::tasks::v2::ListTasksRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::tasks::v2::Task>>(
      std::move(request),
      [](google::cloud::tasks::v2::ListTasksRequest const&) {
        return StatusOr<google::cloud::tasks::v2::ListTasksResponse>{};
      },
      [](google::cloud::tasks::v2::ListTasksResponse const&) {
        return std::vector<google::cloud::tasks::v2::Task>();
      });
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksConnection::GetTask(
    google::cloud::tasks::v2::GetTaskRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksConnection::CreateTask(
    google::cloud::tasks::v2::CreateTaskRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status CloudTasksConnection::DeleteTask(
    google::cloud::tasks::v2::DeleteTaskRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksConnection::RunTask(
    google::cloud::tasks::v2::RunTaskRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<CloudTasksConnection> MakeCloudTasksConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 CloudTasksPolicyOptionList>(options, __func__);
  options = tasks_internal::CloudTasksDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      tasks_internal::CreateDefaultCloudTasksStub(background->cq(), options);
  return std::make_shared<tasks_internal::CloudTasksConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace tasks_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<tasks::CloudTasksConnection> MakeCloudTasksConnection(
    std::shared_ptr<CloudTasksStub> stub, Options options) {
  options = CloudTasksDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<tasks_internal::CloudTasksConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks_internal
}  // namespace cloud
}  // namespace google
