// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tasks/v2/cloudtasks.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TASKS_CLOUD_TASKS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TASKS_CLOUD_TASKS_CLIENT_H

#include "google/cloud/tasks/cloud_tasks_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/iam_updater.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace tasks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Cloud Tasks allows developers to manage the execution of background
/// work in their applications.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CloudTasksClient {
 public:
  explicit CloudTasksClient(std::shared_ptr<CloudTasksConnection> connection,
                            Options options = {});
  ~CloudTasksClient();

  //@{
  // @name Copy and move support
  CloudTasksClient(CloudTasksClient const&) = default;
  CloudTasksClient& operator=(CloudTasksClient const&) = default;
  CloudTasksClient(CloudTasksClient&&) = default;
  CloudTasksClient& operator=(CloudTasksClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(CloudTasksClient const& a, CloudTasksClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CloudTasksClient const& a, CloudTasksClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists queues.
  ///
  /// Queues are returned in lexicographical order.
  ///
  /// @param parent  Required. The location name.
  ///  For example: `projects/PROJECT_ID/locations/LOCATION_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.ListQueuesRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L308}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StreamRange<google::cloud::tasks::v2::Queue> ListQueues(
      std::string const& parent, Options options = {});

  ///
  /// Lists queues.
  ///
  /// Queues are returned in lexicographical order.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::ListQueuesRequest,google/cloud/tasks/v2/cloudtasks.proto#L308}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.ListQueuesRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L308}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StreamRange<google::cloud::tasks::v2::Queue> ListQueues(
      google::cloud::tasks::v2::ListQueuesRequest request,
      Options options = {});

  ///
  /// Gets a queue.
  ///
  /// @param name  Required. The resource name of the queue. For example:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.GetQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L369}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> GetQueue(std::string const& name,
                                                     Options options = {});

  ///
  /// Gets a queue.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::GetQueueRequest,google/cloud/tasks/v2/cloudtasks.proto#L369}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.GetQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L369}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> GetQueue(
      google::cloud::tasks::v2::GetQueueRequest const& request,
      Options options = {});

  ///
  /// Creates a queue.
  ///
  /// Queues created with this method allow tasks to live for a maximum of 31
  /// days. After a task is 31 days old, the task will be deleted regardless of
  /// whether it was dispatched or not.
  ///
  /// WARNING: Using this method may have unintended side effects if you are
  /// using an App Engine `queue.yaml` or `queue.xml` file to manage your
  /// queues. Read [Overview of Queue Management and
  /// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
  /// this method.
  ///
  /// @param parent  Required. The location name in which the queue will be
  /// created.
  ///  For example: `projects/PROJECT_ID/locations/LOCATION_ID`
  ///  The list of allowed locations can be obtained by calling Cloud
  ///  Tasks' implementation of
  ///  [ListLocations][google.cloud.location.Locations.ListLocations].
  /// @param queue  Required. The queue to create.
  ///  [Queue's name][google.cloud.tasks.v2.Queue.name] cannot be the same as an
  ///  existing queue.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.CreateQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L381}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> CreateQueue(
      std::string const& parent, google::cloud::tasks::v2::Queue const& queue,
      Options options = {});

  ///
  /// Creates a queue.
  ///
  /// Queues created with this method allow tasks to live for a maximum of 31
  /// days. After a task is 31 days old, the task will be deleted regardless of
  /// whether it was dispatched or not.
  ///
  /// WARNING: Using this method may have unintended side effects if you are
  /// using an App Engine `queue.yaml` or `queue.xml` file to manage your
  /// queues. Read [Overview of Queue Management and
  /// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
  /// this method.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::CreateQueueRequest,google/cloud/tasks/v2/cloudtasks.proto#L381}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.CreateQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L381}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> CreateQueue(
      google::cloud::tasks::v2::CreateQueueRequest const& request,
      Options options = {});

  ///
  /// Updates a queue.
  ///
  /// This method creates the queue if it does not exist and updates
  /// the queue if it does exist.
  ///
  /// Queues created with this method allow tasks to live for a maximum of 31
  /// days. After a task is 31 days old, the task will be deleted regardless of
  /// whether it was dispatched or not.
  ///
  /// WARNING: Using this method may have unintended side effects if you are
  /// using an App Engine `queue.yaml` or `queue.xml` file to manage your
  /// queues. Read [Overview of Queue Management and
  /// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
  /// this method.
  ///
  /// @param queue  Required. The queue to create or update.
  ///  The queue's [name][google.cloud.tasks.v2.Queue.name] must be specified.
  ///  Output only fields cannot be modified using UpdateQueue.
  ///  Any value specified for an output only field will be ignored.
  ///  The queue's [name][google.cloud.tasks.v2.Queue.name] cannot be changed.
  /// @param update_mask  A mask used to specify which fields of the queue are
  /// being updated.
  ///  If empty, then all fields will be updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.UpdateQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L402}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> UpdateQueue(
      google::cloud::tasks::v2::Queue const& queue,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a queue.
  ///
  /// This method creates the queue if it does not exist and updates
  /// the queue if it does exist.
  ///
  /// Queues created with this method allow tasks to live for a maximum of 31
  /// days. After a task is 31 days old, the task will be deleted regardless of
  /// whether it was dispatched or not.
  ///
  /// WARNING: Using this method may have unintended side effects if you are
  /// using an App Engine `queue.yaml` or `queue.xml` file to manage your
  /// queues. Read [Overview of Queue Management and
  /// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
  /// this method.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::UpdateQueueRequest,google/cloud/tasks/v2/cloudtasks.proto#L402}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.UpdateQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L402}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> UpdateQueue(
      google::cloud::tasks::v2::UpdateQueueRequest const& request,
      Options options = {});

  ///
  /// Deletes a queue.
  ///
  /// This command will delete the queue even if it has tasks in it.
  ///
  /// Note: If you delete a queue, a queue with the same name can't be created
  /// for 7 days.
  ///
  /// WARNING: Using this method may have unintended side effects if you are
  /// using an App Engine `queue.yaml` or `queue.xml` file to manage your
  /// queues. Read [Overview of Queue Management and
  /// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
  /// this method.
  ///
  /// @param name  Required. The queue name. For example:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.tasks.v2.DeleteQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L419}
  ///
  Status DeleteQueue(std::string const& name, Options options = {});

  ///
  /// Deletes a queue.
  ///
  /// This command will delete the queue even if it has tasks in it.
  ///
  /// Note: If you delete a queue, a queue with the same name can't be created
  /// for 7 days.
  ///
  /// WARNING: Using this method may have unintended side effects if you are
  /// using an App Engine `queue.yaml` or `queue.xml` file to manage your
  /// queues. Read [Overview of Queue Management and
  /// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
  /// this method.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::DeleteQueueRequest,google/cloud/tasks/v2/cloudtasks.proto#L419}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.tasks.v2.DeleteQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L419}
  ///
  Status DeleteQueue(
      google::cloud::tasks::v2::DeleteQueueRequest const& request,
      Options options = {});

  ///
  /// Purges a queue by deleting all of its tasks.
  ///
  /// All tasks created before this method is called are permanently deleted.
  ///
  /// Purge operations can take up to one minute to take effect. Tasks
  /// might be dispatched before the purge takes effect. A purge is
  /// irreversible.
  ///
  /// @param name  Required. The queue name. For example:
  ///  `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.PurgeQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L431}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> PurgeQueue(std::string const& name,
                                                       Options options = {});

  ///
  /// Purges a queue by deleting all of its tasks.
  ///
  /// All tasks created before this method is called are permanently deleted.
  ///
  /// Purge operations can take up to one minute to take effect. Tasks
  /// might be dispatched before the purge takes effect. A purge is
  /// irreversible.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::PurgeQueueRequest,google/cloud/tasks/v2/cloudtasks.proto#L431}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.PurgeQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L431}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> PurgeQueue(
      google::cloud::tasks::v2::PurgeQueueRequest const& request,
      Options options = {});

  ///
  /// Pauses the queue.
  ///
  /// If a queue is paused then the system will stop dispatching tasks
  /// until the queue is resumed via
  /// [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue]. Tasks can
  /// still be added when the queue is paused. A queue is paused if its
  /// [state][google.cloud.tasks.v2.Queue.state] is
  /// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
  ///
  /// @param name  Required. The queue name. For example:
  ///  `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.PauseQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L443}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> PauseQueue(std::string const& name,
                                                       Options options = {});

  ///
  /// Pauses the queue.
  ///
  /// If a queue is paused then the system will stop dispatching tasks
  /// until the queue is resumed via
  /// [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue]. Tasks can
  /// still be added when the queue is paused. A queue is paused if its
  /// [state][google.cloud.tasks.v2.Queue.state] is
  /// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::PauseQueueRequest,google/cloud/tasks/v2/cloudtasks.proto#L443}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.PauseQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L443}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> PauseQueue(
      google::cloud::tasks::v2::PauseQueueRequest const& request,
      Options options = {});

  ///
  /// Resume a queue.
  ///
  /// This method resumes a queue after it has been
  /// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED] or
  /// [DISABLED][google.cloud.tasks.v2.Queue.State.DISABLED]. The state of a
  /// queue is stored in the queue's [state][google.cloud.tasks.v2.Queue.state];
  /// after calling this method it will be set to
  /// [RUNNING][google.cloud.tasks.v2.Queue.State.RUNNING].
  ///
  /// WARNING: Resuming many high-QPS queues at the same time can
  /// lead to target overloading. If you are resuming high-QPS
  /// queues, follow the 500/50/5 pattern described in
  /// [Managing Cloud Tasks Scaling
  /// Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
  ///
  /// @param name  Required. The queue name. For example:
  ///  `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.ResumeQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L455}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> ResumeQueue(std::string const& name,
                                                        Options options = {});

  ///
  /// Resume a queue.
  ///
  /// This method resumes a queue after it has been
  /// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED] or
  /// [DISABLED][google.cloud.tasks.v2.Queue.State.DISABLED]. The state of a
  /// queue is stored in the queue's [state][google.cloud.tasks.v2.Queue.state];
  /// after calling this method it will be set to
  /// [RUNNING][google.cloud.tasks.v2.Queue.State.RUNNING].
  ///
  /// WARNING: Resuming many high-QPS queues at the same time can
  /// lead to target overloading. If you are resuming high-QPS
  /// queues, follow the 500/50/5 pattern described in
  /// [Managing Cloud Tasks Scaling
  /// Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::ResumeQueueRequest,google/cloud/tasks/v2/cloudtasks.proto#L455}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Queue,google/cloud/tasks/v2/queue.proto#L34}
  ///
  /// [google.cloud.tasks.v2.ResumeQueueRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L455}
  /// [google.cloud.tasks.v2.Queue]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/queue.proto#L34}
  ///
  StatusOr<google::cloud::tasks::v2::Queue> ResumeQueue(
      google::cloud::tasks::v2::ResumeQueueRequest const& request,
      Options options = {});

  ///
  /// Gets the access control policy for a [Queue][google.cloud.tasks.v2.Queue].
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Authorization requires the following
  /// [Google IAM](https://cloud.google.com/iam) permission on the specified
  /// resource parent:
  ///
  /// * `cloudtasks.queues.getIamPolicy`
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(std::string const& resource,
                                                 Options options = {});

  ///
  /// Gets the access control policy for a [Queue][google.cloud.tasks.v2.Queue].
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Authorization requires the following
  /// [Google IAM](https://cloud.google.com/iam) permission on the specified
  /// resource parent:
  ///
  /// * `cloudtasks.queues.getIamPolicy`
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::GetIamPolicyRequest,google/iam/v1/iam_policy.proto#L113}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Sets the access control policy for a [Queue][google.cloud.tasks.v2.Queue].
  /// Replaces any existing policy.
  ///
  /// Note: The Cloud Console does not check queue-level IAM permissions yet.
  /// Project-level permissions are required to use the Cloud Console.
  ///
  /// Authorization requires the following
  /// [Google IAM](https://cloud.google.com/iam) permission on the specified
  /// resource parent:
  ///
  /// * `cloudtasks.queues.setIamPolicy`
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// specified.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param policy  REQUIRED: The complete policy to be applied to the
  /// `resource`. The size of
  ///  the policy is limited to a few 10s of KB. An empty policy is a
  ///  valid policy but certain Cloud Platform services (such as Projects)
  ///  might reject them.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      std::string const& resource, google::iam::v1::Policy const& policy,
      Options options = {});

  /**
   * Updates the IAM policy for @p resource using an optimistic concurrency
   * control loop.
   *
   * The loop fetches the current policy for @p resource, and passes it to @p
   * updater, which should return the new policy. This new policy should use the
   * current etag so that the read-modify-write cycle can detect races and rerun
   * the update when there is a mismatch. If the new policy does not have an
   * etag, the existing policy will be blindly overwritten. If @p updater does
   * not yield a policy, the control loop is terminated and kCancelled is
   * returned.
   *
   * @param resource  Required. The resource for which the policy is being
   * specified. See the operation documentation for the appropriate value for
   * this field.
   * @param updater  Required. Functor to map the current policy to a new one.
   * @param options  Optional. Options to control the loop. Expected options
   * are:
   *       - `CloudTasksBackoffPolicyOption`
   * @return google::iam::v1::Policy
   */
  StatusOr<google::iam::v1::Policy> SetIamPolicy(std::string const& resource,
                                                 IamUpdater const& updater,
                                                 Options options = {});

  ///
  /// Sets the access control policy for a [Queue][google.cloud.tasks.v2.Queue].
  /// Replaces any existing policy.
  ///
  /// Note: The Cloud Console does not check queue-level IAM permissions yet.
  /// Project-level permissions are required to use the Cloud Console.
  ///
  /// Authorization requires the following
  /// [Google IAM](https://cloud.google.com/iam) permission on the specified
  /// resource parent:
  ///
  /// * `cloudtasks.queues.setIamPolicy`
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::SetIamPolicyRequest,google/iam/v1/iam_policy.proto#L98}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Returns permissions that a caller has on a
  /// [Queue][google.cloud.tasks.v2.Queue]. If the resource does not exist, this
  /// will return an empty set of permissions, not a
  /// [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
  ///
  /// Note: This operation is designed to be used for building permission-aware
  /// UIs and command-line tools, not for authorization checking. This operation
  /// may "fail open" without warning.
  ///
  /// @param resource  REQUIRED: The resource for which the policy detail is
  /// being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param permissions  The set of permissions to check for the `resource`.
  /// Permissions with
  ///  wildcards (such as '*' or 'storage.*') are not allowed. For more
  ///  information see
  ///  [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      std::string const& resource, std::vector<std::string> const& permissions,
      Options options = {});

  ///
  /// Returns permissions that a caller has on a
  /// [Queue][google.cloud.tasks.v2.Queue]. If the resource does not exist, this
  /// will return an empty set of permissions, not a
  /// [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
  ///
  /// Note: This operation is designed to be used for building permission-aware
  /// UIs and command-line tools, not for authorization checking. This operation
  /// may "fail open" without warning.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::TestIamPermissionsRequest,google/iam/v1/iam_policy.proto#L126}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options options = {});

  ///
  /// Lists the tasks in a queue.
  ///
  /// By default, only the [BASIC][google.cloud.tasks.v2.Task.View.BASIC] view
  /// is retrieved due to performance considerations;
  /// [response_view][google.cloud.tasks.v2.ListTasksRequest.response_view]
  /// controls the subset of information which is returned.
  ///
  /// The tasks may be returned in any order. The ordering may change at any
  /// time.
  ///
  /// @param parent  Required. The queue name. For example:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.ListTasksRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L467}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StreamRange<google::cloud::tasks::v2::Task> ListTasks(
      std::string const& parent, Options options = {});

  ///
  /// Lists the tasks in a queue.
  ///
  /// By default, only the [BASIC][google.cloud.tasks.v2.Task.View.BASIC] view
  /// is retrieved due to performance considerations;
  /// [response_view][google.cloud.tasks.v2.ListTasksRequest.response_view]
  /// controls the subset of information which is returned.
  ///
  /// The tasks may be returned in any order. The ordering may change at any
  /// time.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::ListTasksRequest,google/cloud/tasks/v2/cloudtasks.proto#L467}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.ListTasksRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L467}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StreamRange<google::cloud::tasks::v2::Task> ListTasks(
      google::cloud::tasks::v2::ListTasksRequest request, Options options = {});

  ///
  /// Gets a task.
  ///
  /// @param name  Required. The task name. For example:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.GetTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L529}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StatusOr<google::cloud::tasks::v2::Task> GetTask(std::string const& name,
                                                   Options options = {});

  ///
  /// Gets a task.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::GetTaskRequest,google/cloud/tasks/v2/cloudtasks.proto#L529}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.GetTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L529}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StatusOr<google::cloud::tasks::v2::Task> GetTask(
      google::cloud::tasks::v2::GetTaskRequest const& request,
      Options options = {});

  ///
  /// Creates a task and adds it to a queue.
  ///
  /// Tasks cannot be updated after creation; there is no UpdateTask command.
  ///
  /// * The maximum task size is 100KB.
  ///
  /// @param parent  Required. The queue name. For example:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
  ///  The queue must already exist.
  /// @param task  Required. The task to add.
  ///  Task names have the following format:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
  ///  The user can optionally specify a task
  ///  [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
  ///  the system will generate a random unique task id, which will be set in
  ///  the task returned in the [response][google.cloud.tasks.v2.Task.name]. If
  ///  [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
  ///  is in the past then Cloud Tasks will set it to the current time. Task
  ///  De-duplication: Explicitly specifying a task ID enables task
  ///  de-duplication.  If a task's ID is identical to that of an existing task
  ///  or a task that was deleted or executed recently then the call will fail
  ///  with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
  ///  If the task's queue was created using Cloud Tasks, then another task with
  ///  the same name can't be created for ~1hour after the original task was
  ///  deleted or executed. If the task's queue was created using queue.yaml or
  ///  queue.xml, then another task with the same name can't be created
  ///  for ~9days after the original task was deleted or executed.
  ///  Because there is an extra lookup cost to identify duplicate task
  ///  names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
  ///  calls have significantly increased latency. Using hashed strings for the
  ///  task id or for the prefix of the task id is recommended. Choosing task
  ///  ids that are sequential or have sequential prefixes, for example using a
  ///  timestamp, causes an increase in latency and error rates in all
  ///  task commands. The infrastructure relies on an approximately
  ///  uniform distribution of task ids to store and serve tasks
  ///  efficiently.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.CreateTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L555}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StatusOr<google::cloud::tasks::v2::Task> CreateTask(
      std::string const& parent, google::cloud::tasks::v2::Task const& task,
      Options options = {});

  ///
  /// Creates a task and adds it to a queue.
  ///
  /// Tasks cannot be updated after creation; there is no UpdateTask command.
  ///
  /// * The maximum task size is 100KB.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::CreateTaskRequest,google/cloud/tasks/v2/cloudtasks.proto#L555}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.CreateTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L555}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StatusOr<google::cloud::tasks::v2::Task> CreateTask(
      google::cloud::tasks::v2::CreateTaskRequest const& request,
      Options options = {});

  ///
  /// Deletes a task.
  ///
  /// A task can be deleted if it is scheduled or dispatched. A task
  /// cannot be deleted if it has executed successfully or permanently
  /// failed.
  ///
  /// @param name  Required. The task name. For example:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.tasks.v2.DeleteTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L619}
  ///
  Status DeleteTask(std::string const& name, Options options = {});

  ///
  /// Deletes a task.
  ///
  /// A task can be deleted if it is scheduled or dispatched. A task
  /// cannot be deleted if it has executed successfully or permanently
  /// failed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::DeleteTaskRequest,google/cloud/tasks/v2/cloudtasks.proto#L619}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.tasks.v2.DeleteTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L619}
  ///
  Status DeleteTask(google::cloud::tasks::v2::DeleteTaskRequest const& request,
                    Options options = {});

  ///
  /// Forces a task to run now.
  ///
  /// When this method is called, Cloud Tasks will dispatch the task, even if
  /// the task is already running, the queue has reached its
  /// [RateLimits][google.cloud.tasks.v2.RateLimits] or is
  /// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
  ///
  /// This command is meant to be used for manual debugging. For
  /// example, [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] can be used
  /// to retry a failed task after a fix has been made or to manually force a
  /// task to be dispatched now.
  ///
  /// The dispatched task is returned. That is, the task that is returned
  /// contains the [status][Task.status] after the task is dispatched but
  /// before the task is received by its target.
  ///
  /// If Cloud Tasks receives a successful response from the task's
  /// target, then the task will be deleted; otherwise the task's
  /// [schedule_time][google.cloud.tasks.v2.Task.schedule_time] will be reset to
  /// the time that [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] was
  /// called plus the retry delay specified in the queue's
  /// [RetryConfig][google.cloud.tasks.v2.RetryConfig].
  ///
  /// [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] returns
  /// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
  /// task that has already succeeded or permanently failed.
  ///
  /// @param name  Required. The task name. For example:
  ///  `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.RunTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L632}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StatusOr<google::cloud::tasks::v2::Task> RunTask(std::string const& name,
                                                   Options options = {});

  ///
  /// Forces a task to run now.
  ///
  /// When this method is called, Cloud Tasks will dispatch the task, even if
  /// the task is already running, the queue has reached its
  /// [RateLimits][google.cloud.tasks.v2.RateLimits] or is
  /// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
  ///
  /// This command is meant to be used for manual debugging. For
  /// example, [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] can be used
  /// to retry a failed task after a fix has been made or to manually force a
  /// task to be dispatched now.
  ///
  /// The dispatched task is returned. That is, the task that is returned
  /// contains the [status][Task.status] after the task is dispatched but
  /// before the task is received by its target.
  ///
  /// If Cloud Tasks receives a successful response from the task's
  /// target, then the task will be deleted; otherwise the task's
  /// [schedule_time][google.cloud.tasks.v2.Task.schedule_time] will be reset to
  /// the time that [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] was
  /// called plus the retry delay specified in the queue's
  /// [RetryConfig][google.cloud.tasks.v2.RetryConfig].
  ///
  /// [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] returns
  /// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
  /// task that has already succeeded or permanently failed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::tasks::v2::RunTaskRequest,google/cloud/tasks/v2/cloudtasks.proto#L632}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::tasks::v2::Task,google/cloud/tasks/v2/task.proto#L33}
  ///
  /// [google.cloud.tasks.v2.RunTaskRequest]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/cloudtasks.proto#L632}
  /// [google.cloud.tasks.v2.Task]:
  /// @googleapis_reference_link{google/cloud/tasks/v2/task.proto#L33}
  ///
  StatusOr<google::cloud::tasks::v2::Task> RunTask(
      google::cloud::tasks::v2::RunTaskRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<CloudTasksConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TASKS_CLOUD_TASKS_CLIENT_H
