// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/tenant_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TALENT_TENANT_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TALENT_TENANT_CONNECTION_H

#include "google/cloud/talent/internal/tenant_retry_traits.h"
#include "google/cloud/talent/internal/tenant_stub.h"
#include "google/cloud/talent/tenant_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace talent {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using TenantServiceRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        talent_internal::TenantServiceRetryTraits>;

using TenantServiceLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        talent_internal::TenantServiceRetryTraits>;

using TenantServiceLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        talent_internal::TenantServiceRetryTraits>;

class TenantServiceConnection {
 public:
  virtual ~TenantServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::talent::v4::Tenant> CreateTenant(
      google::cloud::talent::v4::CreateTenantRequest const& request);

  virtual StatusOr<google::cloud::talent::v4::Tenant> GetTenant(
      google::cloud::talent::v4::GetTenantRequest const& request);

  virtual StatusOr<google::cloud::talent::v4::Tenant> UpdateTenant(
      google::cloud::talent::v4::UpdateTenantRequest const& request);

  virtual Status DeleteTenant(
      google::cloud::talent::v4::DeleteTenantRequest const& request);

  virtual StreamRange<google::cloud::talent::v4::Tenant> ListTenants(
      google::cloud::talent::v4::ListTenantsRequest request);
};

std::shared_ptr<TenantServiceConnection> MakeTenantServiceConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace talent_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<talent::TenantServiceConnection> MakeTenantServiceConnection(
    std::shared_ptr<TenantServiceStub> stub, Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TALENT_TENANT_CONNECTION_H
