// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/tenant_service.proto

#include "google/cloud/talent/tenant_client.h"
#include "google/cloud/talent/internal/tenant_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace talent {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TenantServiceClient::TenantServiceClient(
    std::shared_ptr<TenantServiceConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), talent_internal::TenantServiceDefaultOptions(
                                  connection_->options()))) {}
TenantServiceClient::~TenantServiceClient() = default;

StatusOr<google::cloud::talent::v4::Tenant> TenantServiceClient::CreateTenant(
    std::string const& parent, google::cloud::talent::v4::Tenant const& tenant,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::talent::v4::CreateTenantRequest request;
  request.set_parent(parent);
  *request.mutable_tenant() = tenant;
  return connection_->CreateTenant(request);
}

StatusOr<google::cloud::talent::v4::Tenant> TenantServiceClient::CreateTenant(
    google::cloud::talent::v4::CreateTenantRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateTenant(request);
}

StatusOr<google::cloud::talent::v4::Tenant> TenantServiceClient::GetTenant(
    std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::talent::v4::GetTenantRequest request;
  request.set_name(name);
  return connection_->GetTenant(request);
}

StatusOr<google::cloud::talent::v4::Tenant> TenantServiceClient::GetTenant(
    google::cloud::talent::v4::GetTenantRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetTenant(request);
}

StatusOr<google::cloud::talent::v4::Tenant> TenantServiceClient::UpdateTenant(
    google::cloud::talent::v4::Tenant const& tenant,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::talent::v4::UpdateTenantRequest request;
  *request.mutable_tenant() = tenant;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTenant(request);
}

StatusOr<google::cloud::talent::v4::Tenant> TenantServiceClient::UpdateTenant(
    google::cloud::talent::v4::UpdateTenantRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateTenant(request);
}

Status TenantServiceClient::DeleteTenant(std::string const& name,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::talent::v4::DeleteTenantRequest request;
  request.set_name(name);
  return connection_->DeleteTenant(request);
}

Status TenantServiceClient::DeleteTenant(
    google::cloud::talent::v4::DeleteTenantRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteTenant(request);
}

StreamRange<google::cloud::talent::v4::Tenant> TenantServiceClient::ListTenants(
    std::string const& parent, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::talent::v4::ListTenantsRequest request;
  request.set_parent(parent);
  return connection_->ListTenants(request);
}

StreamRange<google::cloud::talent::v4::Tenant> TenantServiceClient::ListTenants(
    google::cloud::talent::v4::ListTenantsRequest request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListTenants(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent
}  // namespace cloud
}  // namespace google
