// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/job_service.proto

#include "google/cloud/talent/job_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace talent {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

JobServiceConnectionIdempotencyPolicy::
    ~JobServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultJobServiceConnectionIdempotencyPolicy
    : public JobServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultJobServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<JobServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultJobServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency CreateJob(
      google::cloud::talent::v4::CreateJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency BatchCreateJobs(
      google::cloud::talent::v4::BatchCreateJobsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetJob(google::cloud::talent::v4::GetJobRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateJob(
      google::cloud::talent::v4::UpdateJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency BatchUpdateJobs(
      google::cloud::talent::v4::BatchUpdateJobsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteJob(
      google::cloud::talent::v4::DeleteJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency BatchDeleteJobs(
      google::cloud::talent::v4::BatchDeleteJobsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListJobs(google::cloud::talent::v4::ListJobsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency SearchJobs(
      google::cloud::talent::v4::SearchJobsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SearchJobsForAlert(
      google::cloud::talent::v4::SearchJobsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<JobServiceConnectionIdempotencyPolicy>
MakeDefaultJobServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultJobServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent
}  // namespace cloud
}  // namespace google
