// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/tenant_service.proto

#include "google/cloud/talent/internal/tenant_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/talent/v4/tenant_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace talent_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TenantServiceStub::~TenantServiceStub() = default;

StatusOr<google::cloud::talent::v4::Tenant>
DefaultTenantServiceStub::CreateTenant(
    grpc::ClientContext& client_context,
    google::cloud::talent::v4::CreateTenantRequest const& request) {
  google::cloud::talent::v4::Tenant response;
  auto status = grpc_stub_->CreateTenant(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::talent::v4::Tenant> DefaultTenantServiceStub::GetTenant(
    grpc::ClientContext& client_context,
    google::cloud::talent::v4::GetTenantRequest const& request) {
  google::cloud::talent::v4::Tenant response;
  auto status = grpc_stub_->GetTenant(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::talent::v4::Tenant>
DefaultTenantServiceStub::UpdateTenant(
    grpc::ClientContext& client_context,
    google::cloud::talent::v4::UpdateTenantRequest const& request) {
  google::cloud::talent::v4::Tenant response;
  auto status = grpc_stub_->UpdateTenant(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultTenantServiceStub::DeleteTenant(
    grpc::ClientContext& client_context,
    google::cloud::talent::v4::DeleteTenantRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteTenant(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::talent::v4::ListTenantsResponse>
DefaultTenantServiceStub::ListTenants(
    grpc::ClientContext& client_context,
    google::cloud::talent::v4::ListTenantsRequest const& request) {
  google::cloud::talent::v4::ListTenantsResponse response;
  auto status = grpc_stub_->ListTenants(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_internal
}  // namespace cloud
}  // namespace google
