// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/tenant_service.proto

#include "google/cloud/talent/internal/tenant_connection_impl.h"
#include "google/cloud/talent/internal/tenant_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace talent_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TenantServiceConnectionImpl::TenantServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<talent_internal::TenantServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), talent_internal::TenantServiceDefaultOptions(
                                  TenantServiceConnection::options()))) {}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::CreateTenant(
    google::cloud::talent::v4::CreateTenantRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateTenant(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::CreateTenantRequest const& request) {
        return stub_->CreateTenant(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::GetTenant(
    google::cloud::talent::v4::GetTenantRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetTenant(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::GetTenantRequest const& request) {
        return stub_->GetTenant(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::UpdateTenant(
    google::cloud::talent::v4::UpdateTenantRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateTenant(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::UpdateTenantRequest const& request) {
        return stub_->UpdateTenant(context, request);
      },
      request, __func__);
}

Status TenantServiceConnectionImpl::DeleteTenant(
    google::cloud::talent::v4::DeleteTenantRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteTenant(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::DeleteTenantRequest const& request) {
        return stub_->DeleteTenant(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::talent::v4::Tenant>
TenantServiceConnectionImpl::ListTenants(
    google::cloud::talent::v4::ListTenantsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<talent::TenantServiceRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListTenants(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::talent::v4::Tenant>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::talent::v4::ListTenantsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::talent::v4::ListTenantsRequest const& request) {
              return stub->ListTenants(context, request);
            },
            r, function_name);
      },
      [](google::cloud::talent::v4::ListTenantsResponse r) {
        std::vector<google::cloud::talent::v4::Tenant> result(
            r.tenants().size());
        auto& messages = *r.mutable_tenants();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_internal
}  // namespace cloud
}  // namespace google
