// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/job_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TALENT_INTERNAL_JOB_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TALENT_INTERNAL_JOB_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/talent/v4/job_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace talent_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class JobServiceStub {
 public:
  virtual ~JobServiceStub() = 0;

  virtual StatusOr<google::cloud::talent::v4::Job> CreateJob(
      grpc::ClientContext& context,
      google::cloud::talent::v4::CreateJobRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncBatchCreateJobs(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::talent::v4::BatchCreateJobsRequest const& request) = 0;

  virtual StatusOr<google::cloud::talent::v4::Job> GetJob(
      grpc::ClientContext& context,
      google::cloud::talent::v4::GetJobRequest const& request) = 0;

  virtual StatusOr<google::cloud::talent::v4::Job> UpdateJob(
      grpc::ClientContext& context,
      google::cloud::talent::v4::UpdateJobRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncBatchUpdateJobs(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::talent::v4::BatchUpdateJobsRequest const& request) = 0;

  virtual Status DeleteJob(
      grpc::ClientContext& context,
      google::cloud::talent::v4::DeleteJobRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncBatchDeleteJobs(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::talent::v4::BatchDeleteJobsRequest const& request) = 0;

  virtual StatusOr<google::cloud::talent::v4::ListJobsResponse> ListJobs(
      grpc::ClientContext& context,
      google::cloud::talent::v4::ListJobsRequest const& request) = 0;

  virtual StatusOr<google::cloud::talent::v4::SearchJobsResponse> SearchJobs(
      grpc::ClientContext& context,
      google::cloud::talent::v4::SearchJobsRequest const& request) = 0;

  virtual StatusOr<google::cloud::talent::v4::SearchJobsResponse>
  SearchJobsForAlert(
      grpc::ClientContext& context,
      google::cloud::talent::v4::SearchJobsRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultJobServiceStub : public JobServiceStub {
 public:
  DefaultJobServiceStub(
      std::unique_ptr<google::cloud::talent::v4::JobService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::talent::v4::Job> CreateJob(
      grpc::ClientContext& client_context,
      google::cloud::talent::v4::CreateJobRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchCreateJobs(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::talent::v4::BatchCreateJobsRequest const& request)
      override;

  StatusOr<google::cloud::talent::v4::Job> GetJob(
      grpc::ClientContext& client_context,
      google::cloud::talent::v4::GetJobRequest const& request) override;

  StatusOr<google::cloud::talent::v4::Job> UpdateJob(
      grpc::ClientContext& client_context,
      google::cloud::talent::v4::UpdateJobRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchUpdateJobs(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::talent::v4::BatchUpdateJobsRequest const& request)
      override;

  Status DeleteJob(
      grpc::ClientContext& client_context,
      google::cloud::talent::v4::DeleteJobRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncBatchDeleteJobs(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::talent::v4::BatchDeleteJobsRequest const& request)
      override;

  StatusOr<google::cloud::talent::v4::ListJobsResponse> ListJobs(
      grpc::ClientContext& client_context,
      google::cloud::talent::v4::ListJobsRequest const& request) override;

  StatusOr<google::cloud::talent::v4::SearchJobsResponse> SearchJobs(
      grpc::ClientContext& client_context,
      google::cloud::talent::v4::SearchJobsRequest const& request) override;

  StatusOr<google::cloud::talent::v4::SearchJobsResponse> SearchJobsForAlert(
      grpc::ClientContext& client_context,
      google::cloud::talent::v4::SearchJobsRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::talent::v4::JobService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TALENT_INTERNAL_JOB_STUB_H
