// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/job_service.proto

#include "google/cloud/talent/internal/job_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/talent/v4/job_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace talent_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

JobServiceMetadata::JobServiceMetadata(std::shared_ptr<JobServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::talent::v4::Job> JobServiceMetadata::CreateJob(
    grpc::ClientContext& context,
    google::cloud::talent::v4::CreateJobRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateJob(context, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncBatchCreateJobs(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::talent::v4::BatchCreateJobsRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncBatchCreateJobs(cq, std::move(context), request);
}

StatusOr<google::cloud::talent::v4::Job> JobServiceMetadata::GetJob(
    grpc::ClientContext& context,
    google::cloud::talent::v4::GetJobRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetJob(context, request);
}

StatusOr<google::cloud::talent::v4::Job> JobServiceMetadata::UpdateJob(
    grpc::ClientContext& context,
    google::cloud::talent::v4::UpdateJobRequest const& request) {
  SetMetadata(context, "job.name=" + request.job().name());
  return child_->UpdateJob(context, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncBatchUpdateJobs(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::talent::v4::BatchUpdateJobsRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncBatchUpdateJobs(cq, std::move(context), request);
}

Status JobServiceMetadata::DeleteJob(
    grpc::ClientContext& context,
    google::cloud::talent::v4::DeleteJobRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteJob(context, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncBatchDeleteJobs(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::talent::v4::BatchDeleteJobsRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncBatchDeleteJobs(cq, std::move(context), request);
}

StatusOr<google::cloud::talent::v4::ListJobsResponse>
JobServiceMetadata::ListJobs(
    grpc::ClientContext& context,
    google::cloud::talent::v4::ListJobsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListJobs(context, request);
}

StatusOr<google::cloud::talent::v4::SearchJobsResponse>
JobServiceMetadata::SearchJobs(
    grpc::ClientContext& context,
    google::cloud::talent::v4::SearchJobsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->SearchJobs(context, request);
}

StatusOr<google::cloud::talent::v4::SearchJobsResponse>
JobServiceMetadata::SearchJobsForAlert(
    grpc::ClientContext& context,
    google::cloud::talent::v4::SearchJobsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->SearchJobsForAlert(context, request);
}

future<StatusOr<google::longrunning::Operation>>
JobServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> JobServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void JobServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                     std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void JobServiceMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_internal
}  // namespace cloud
}  // namespace google
