// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/company_service.proto

#include "google/cloud/talent/internal/company_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/talent/v4/company_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace talent_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CompanyServiceLogging::CompanyServiceLogging(
    std::shared_ptr<CompanyServiceStub> child, TracingOptions tracing_options,
    std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceLogging::CreateCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::CreateCompanyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::CreateCompanyRequest const& request) {
        return child_->CreateCompany(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::talent::v4::Company> CompanyServiceLogging::GetCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::GetCompanyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::GetCompanyRequest const& request) {
        return child_->GetCompany(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceLogging::UpdateCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::UpdateCompanyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::UpdateCompanyRequest const& request) {
        return child_->UpdateCompany(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status CompanyServiceLogging::DeleteCompany(
    grpc::ClientContext& context,
    google::cloud::talent::v4::DeleteCompanyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::DeleteCompanyRequest const& request) {
        return child_->DeleteCompany(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::talent::v4::ListCompaniesResponse>
CompanyServiceLogging::ListCompanies(
    grpc::ClientContext& context,
    google::cloud::talent::v4::ListCompaniesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::ListCompaniesRequest const& request) {
        return child_->ListCompanies(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_internal
}  // namespace cloud
}  // namespace google
