// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/company_service.proto

#include "google/cloud/talent/internal/company_connection_impl.h"
#include "google/cloud/talent/internal/company_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace talent_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CompanyServiceConnectionImpl::CompanyServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<talent_internal::CompanyServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), talent_internal::CompanyServiceDefaultOptions(
                                  CompanyServiceConnection::options()))) {}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::CreateCompany(
    google::cloud::talent::v4::CreateCompanyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateCompany(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::CreateCompanyRequest const& request) {
        return stub_->CreateCompany(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::GetCompany(
    google::cloud::talent::v4::GetCompanyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetCompany(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::GetCompanyRequest const& request) {
        return stub_->GetCompany(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::UpdateCompany(
    google::cloud::talent::v4::UpdateCompanyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateCompany(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::UpdateCompanyRequest const& request) {
        return stub_->UpdateCompany(context, request);
      },
      request, __func__);
}

Status CompanyServiceConnectionImpl::DeleteCompany(
    google::cloud::talent::v4::DeleteCompanyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteCompany(request),
      [this](grpc::ClientContext& context,
             google::cloud::talent::v4::DeleteCompanyRequest const& request) {
        return stub_->DeleteCompany(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::talent::v4::Company>
CompanyServiceConnectionImpl::ListCompanies(
    google::cloud::talent::v4::ListCompaniesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<talent::CompanyServiceRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListCompanies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::talent::v4::Company>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::talent::v4::ListCompaniesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::talent::v4::ListCompaniesRequest const&
                       request) {
              return stub->ListCompanies(context, request);
            },
            r, function_name);
      },
      [](google::cloud::talent::v4::ListCompaniesResponse r) {
        std::vector<google::cloud::talent::v4::Company> result(
            r.companies().size());
        auto& messages = *r.mutable_companies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_internal
}  // namespace cloud
}  // namespace google
