// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storagetransfer/v1/transfer.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGETRANSFER_STORAGE_TRANSFER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGETRANSFER_STORAGE_TRANSFER_CLIENT_H

#include "google/cloud/storagetransfer/storage_transfer_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace storagetransfer {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Storage Transfer Service and its protos.
/// Transfers data between between Google Cloud Storage buckets or from a data
/// source external to Google to a Cloud Storage bucket.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class StorageTransferServiceClient {
 public:
  explicit StorageTransferServiceClient(
      std::shared_ptr<StorageTransferServiceConnection> connection,
      Options options = {});
  ~StorageTransferServiceClient();

  //@{
  // @name Copy and move support
  StorageTransferServiceClient(StorageTransferServiceClient const&) = default;
  StorageTransferServiceClient& operator=(StorageTransferServiceClient const&) =
      default;
  StorageTransferServiceClient(StorageTransferServiceClient&&) = default;
  StorageTransferServiceClient& operator=(StorageTransferServiceClient&&) =
      default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(StorageTransferServiceClient const& a,
                         StorageTransferServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(StorageTransferServiceClient const& a,
                         StorageTransferServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Returns the Google service account that is used by Storage Transfer
  /// Service to access buckets in the project where transfers
  /// run or in other projects. Each Google service account is associated
  /// with one Google Cloud Platform Console project. Users
  /// should add this service account to the Google Cloud Storage bucket
  /// ACLs to grant access to Storage Transfer Service. This service
  /// account is created and owned by Storage Transfer Service and can
  /// only be used by Storage Transfer Service.
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::GetGoogleServiceAccountRequest,google/storagetransfer/v1/transfer.proto#L132}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::storagetransfer::v1::GoogleServiceAccount,google/storagetransfer/v1/transfer_types.proto#L37}
  ///
  /// [google.storagetransfer.v1.GetGoogleServiceAccountRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L132}
  /// [google.storagetransfer.v1.GoogleServiceAccount]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer_types.proto#L37}
  ///
  StatusOr<google::storagetransfer::v1::GoogleServiceAccount>
  GetGoogleServiceAccount(
      google::storagetransfer::v1::GetGoogleServiceAccountRequest const&
          request,
      Options options = {});

  ///
  /// Creates a transfer job that runs periodically.
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::CreateTransferJobRequest,google/storagetransfer/v1/transfer.proto#L139}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::storagetransfer::v1::TransferJob,google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  /// [google.storagetransfer.v1.CreateTransferJobRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L139}
  /// [google.storagetransfer.v1.TransferJob]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  StatusOr<google::storagetransfer::v1::TransferJob> CreateTransferJob(
      google::storagetransfer::v1::CreateTransferJobRequest const& request,
      Options options = {});

  ///
  /// Updates a transfer job. Updating a job's transfer spec does not affect
  /// transfer operations that are running already.
  ///
  /// **Note:** The job's [status][google.storagetransfer.v1.TransferJob.status]
  /// field can be modified using this RPC (for example, to set a job's status
  /// to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED],
  /// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], or
  /// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED]).
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::UpdateTransferJobRequest,google/storagetransfer/v1/transfer.proto#L145}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::storagetransfer::v1::TransferJob,google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  /// [google.storagetransfer.v1.UpdateTransferJobRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L145}
  /// [google.storagetransfer.v1.TransferJob]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  StatusOr<google::storagetransfer::v1::TransferJob> UpdateTransferJob(
      google::storagetransfer::v1::UpdateTransferJobRequest const& request,
      Options options = {});

  ///
  /// Gets a transfer job.
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::GetTransferJobRequest,google/storagetransfer/v1/transfer.proto#L180}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::storagetransfer::v1::TransferJob,google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  /// [google.storagetransfer.v1.GetTransferJobRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L180}
  /// [google.storagetransfer.v1.TransferJob]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  StatusOr<google::storagetransfer::v1::TransferJob> GetTransferJob(
      google::storagetransfer::v1::GetTransferJobRequest const& request,
      Options options = {});

  ///
  /// Lists transfer jobs.
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::ListTransferJobsRequest,google/storagetransfer/v1/transfer.proto#L192}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::storagetransfer::v1::TransferJob,google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  /// [google.storagetransfer.v1.ListTransferJobsRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L192}
  /// [google.storagetransfer.v1.TransferJob]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer_types.proto#L462}
  ///
  StreamRange<google::storagetransfer::v1::TransferJob> ListTransferJobs(
      google::storagetransfer::v1::ListTransferJobsRequest request,
      Options options = {});

  ///
  /// Pauses a transfer operation.
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::PauseTransferOperationRequest,google/storagetransfer/v1/transfer.proto#L224}
  /// @param options  Optional. Operation options.
  ///
  /// [google.storagetransfer.v1.PauseTransferOperationRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L224}
  ///
  Status PauseTransferOperation(
      google::storagetransfer::v1::PauseTransferOperationRequest const& request,
      Options options = {});

  ///
  /// Resumes a transfer operation that is paused.
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::ResumeTransferOperationRequest,google/storagetransfer/v1/transfer.proto#L230}
  /// @param options  Optional. Operation options.
  ///
  /// [google.storagetransfer.v1.ResumeTransferOperationRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L230}
  ///
  Status ResumeTransferOperation(
      google::storagetransfer::v1::ResumeTransferOperationRequest const&
          request,
      Options options = {});

  ///
  /// Attempts to start a new TransferOperation for the current TransferJob. A
  /// TransferJob has a maximum of one active TransferOperation. If this method
  /// is called while a TransferOperation is active, an error wil be returned.
  ///
  /// @param request
  /// @googleapis_link{google::storagetransfer::v1::RunTransferJobRequest,google/storagetransfer/v1/transfer.proto#L236}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::storagetransfer::v1::TransferOperation,google/storagetransfer/v1/transfer_types.proto#L706}
  ///
  /// [google.storagetransfer.v1.RunTransferJobRequest]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer.proto#L236}
  /// [google.storagetransfer.v1.TransferOperation]:
  /// @googleapis_reference_link{google/storagetransfer/v1/transfer_types.proto#L706}
  ///
  future<StatusOr<google::storagetransfer::v1::TransferOperation>>
  RunTransferJob(
      google::storagetransfer::v1::RunTransferJobRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<StorageTransferServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagetransfer
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGETRANSFER_STORAGE_TRANSFER_CLIENT_H
