// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

#include "google/cloud/spanner/admin/instance_admin_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace spanner_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

InstanceAdminConnectionIdempotencyPolicy::
    ~InstanceAdminConnectionIdempotencyPolicy() = default;

namespace {
class DefaultInstanceAdminConnectionIdempotencyPolicy
    : public InstanceAdminConnectionIdempotencyPolicy {
 public:
  ~DefaultInstanceAdminConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<InstanceAdminConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultInstanceAdminConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListInstanceConfigs(
      google::spanner::admin::instance::v1::ListInstanceConfigsRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetInstanceConfig(
      google::spanner::admin::instance::v1::GetInstanceConfigRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListInstances(
      google::spanner::admin::instance::v1::ListInstancesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetInstance(
      google::spanner::admin::instance::v1::GetInstanceRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateInstance(
      google::spanner::admin::instance::v1::CreateInstanceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateInstance(
      google::spanner::admin::instance::v1::UpdateInstanceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteInstance(
      google::spanner::admin::instance::v1::DeleteInstanceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<InstanceAdminConnectionIdempotencyPolicy>
MakeDefaultInstanceAdminConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultInstanceAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
namespace gcpcxxV1 = GOOGLE_CLOUD_CPP_NS;  // NOLINT(misc-unused-alias-decls)
}  // namespace spanner_admin
}  // namespace cloud
}  // namespace google
