// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/shell/v1/cloudshell.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SHELL_INTERNAL_CLOUD_SHELL_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SHELL_INTERNAL_CLOUD_SHELL_CONNECTION_IMPL_H

#include "google/cloud/shell/cloud_shell_connection.h"
#include "google/cloud/shell/cloud_shell_connection_idempotency_policy.h"
#include "google/cloud/shell/cloud_shell_options.h"
#include "google/cloud/shell/internal/cloud_shell_retry_traits.h"
#include "google/cloud/shell/internal/cloud_shell_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace shell_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudShellServiceConnectionImpl
    : public shell::CloudShellServiceConnection {
 public:
  ~CloudShellServiceConnectionImpl() override = default;

  CloudShellServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<shell_internal::CloudShellServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::shell::v1::Environment> GetEnvironment(
      google::cloud::shell::v1::GetEnvironmentRequest const& request) override;

  future<StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>
  StartEnvironment(google::cloud::shell::v1::StartEnvironmentRequest const&
                       request) override;

  future<StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>
  AuthorizeEnvironment(
      google::cloud::shell::v1::AuthorizeEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>> AddPublicKey(
      google::cloud::shell::v1::AddPublicKeyRequest const& request) override;

  future<StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>
  RemovePublicKey(
      google::cloud::shell::v1::RemovePublicKeyRequest const& request) override;

 private:
  std::unique_ptr<shell::CloudShellServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<shell::CloudShellServiceRetryPolicyOption>()) {
      return options.get<shell::CloudShellServiceRetryPolicyOption>()->clone();
    }
    return options_.get<shell::CloudShellServiceRetryPolicyOption>()->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<shell::CloudShellServiceBackoffPolicyOption>()) {
      return options.get<shell::CloudShellServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<shell::CloudShellServiceBackoffPolicyOption>()->clone();
  }

  std::unique_ptr<shell::CloudShellServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<shell::CloudShellServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<shell::CloudShellServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<shell::CloudShellServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<PollingPolicy> polling_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<shell::CloudShellServicePollingPolicyOption>()) {
      return options.get<shell::CloudShellServicePollingPolicyOption>()
          ->clone();
    }
    return options_.get<shell::CloudShellServicePollingPolicyOption>()->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<shell_internal::CloudShellServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace shell_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SHELL_INTERNAL_CLOUD_SHELL_CONNECTION_IMPL_H
