// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/shell/v1/cloudshell.proto

#include "google/cloud/shell/cloud_shell_client.h"
#include "google/cloud/shell/internal/cloud_shell_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace shell {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudShellServiceClient::CloudShellServiceClient(
    std::shared_ptr<CloudShellServiceConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), shell_internal::CloudShellServiceDefaultOptions(
                                  connection_->options()))) {}
CloudShellServiceClient::~CloudShellServiceClient() = default;

StatusOr<google::cloud::shell::v1::Environment>
CloudShellServiceClient::GetEnvironment(std::string const& name,
                                        Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::shell::v1::GetEnvironmentRequest request;
  request.set_name(name);
  return connection_->GetEnvironment(request);
}

StatusOr<google::cloud::shell::v1::Environment>
CloudShellServiceClient::GetEnvironment(
    google::cloud::shell::v1::GetEnvironmentRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetEnvironment(request);
}

future<StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>
CloudShellServiceClient::StartEnvironment(
    google::cloud::shell::v1::StartEnvironmentRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->StartEnvironment(request);
}

future<StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>
CloudShellServiceClient::AuthorizeEnvironment(
    google::cloud::shell::v1::AuthorizeEnvironmentRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->AuthorizeEnvironment(request);
}

future<StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>>
CloudShellServiceClient::AddPublicKey(
    google::cloud::shell::v1::AddPublicKeyRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->AddPublicKey(request);
}

future<StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>
CloudShellServiceClient::RemovePublicKey(
    google::cloud::shell::v1::RemovePublicKeyRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->RemovePublicKey(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace shell
}  // namespace cloud
}  // namespace google
