// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#include "google/cloud/serviceusage/service_usage_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace serviceusage {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ServiceUsageConnectionIdempotencyPolicy::
    ~ServiceUsageConnectionIdempotencyPolicy() = default;

namespace {
class DefaultServiceUsageConnectionIdempotencyPolicy
    : public ServiceUsageConnectionIdempotencyPolicy {
 public:
  ~DefaultServiceUsageConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ServiceUsageConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultServiceUsageConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency EnableService(
      google::api::serviceusage::v1::EnableServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DisableService(
      google::api::serviceusage::v1::DisableServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetService(
      google::api::serviceusage::v1::GetServiceRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListServices(
      google::api::serviceusage::v1::ListServicesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency BatchEnableServices(
      google::api::serviceusage::v1::BatchEnableServicesRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency BatchGetServices(
      google::api::serviceusage::v1::BatchGetServicesRequest const&) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<ServiceUsageConnectionIdempotencyPolicy>
MakeDefaultServiceUsageConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultServiceUsageConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage
}  // namespace cloud
}  // namespace google
