// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_SERVICE_USAGE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_SERVICE_USAGE_CONNECTION_H

#include "google/cloud/serviceusage/internal/service_usage_retry_traits.h"
#include "google/cloud/serviceusage/internal/service_usage_stub.h"
#include "google/cloud/serviceusage/service_usage_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace serviceusage {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ServiceUsageRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        serviceusage_internal::ServiceUsageRetryTraits>;

using ServiceUsageLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        serviceusage_internal::ServiceUsageRetryTraits>;

using ServiceUsageLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        serviceusage_internal::ServiceUsageRetryTraits>;

class ServiceUsageConnection {
 public:
  virtual ~ServiceUsageConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>
  EnableService(
      google::api::serviceusage::v1::EnableServiceRequest const& request);

  virtual future<
      StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>
  DisableService(
      google::api::serviceusage::v1::DisableServiceRequest const& request);

  virtual StatusOr<google::api::serviceusage::v1::Service> GetService(
      google::api::serviceusage::v1::GetServiceRequest const& request);

  virtual StreamRange<google::api::serviceusage::v1::Service> ListServices(
      google::api::serviceusage::v1::ListServicesRequest request);

  virtual future<
      StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>
  BatchEnableServices(
      google::api::serviceusage::v1::BatchEnableServicesRequest const& request);

  virtual StatusOr<google::api::serviceusage::v1::BatchGetServicesResponse>
  BatchGetServices(
      google::api::serviceusage::v1::BatchGetServicesRequest const& request);
};

std::shared_ptr<ServiceUsageConnection> MakeServiceUsageConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace serviceusage_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<serviceusage::ServiceUsageConnection>
MakeServiceUsageConnection(std::shared_ptr<ServiceUsageStub> stub,
                           Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_SERVICE_USAGE_CONNECTION_H
