// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#include "google/cloud/servicemanagement/service_manager_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicemanagement {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ServiceManagerConnectionIdempotencyPolicy::
    ~ServiceManagerConnectionIdempotencyPolicy() = default;

namespace {
class DefaultServiceManagerConnectionIdempotencyPolicy
    : public ServiceManagerConnectionIdempotencyPolicy {
 public:
  ~DefaultServiceManagerConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ServiceManagerConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultServiceManagerConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListServices(
      google::api::servicemanagement::v1::ListServicesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetService(
      google::api::servicemanagement::v1::GetServiceRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateService(
      google::api::servicemanagement::v1::CreateServiceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteService(
      google::api::servicemanagement::v1::DeleteServiceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UndeleteService(
      google::api::servicemanagement::v1::UndeleteServiceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListServiceConfigs(
      google::api::servicemanagement::v1::ListServiceConfigsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetServiceConfig(
      google::api::servicemanagement::v1::GetServiceConfigRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateServiceConfig(
      google::api::servicemanagement::v1::CreateServiceConfigRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SubmitConfigSource(
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListServiceRollouts(
      google::api::servicemanagement::v1::ListServiceRolloutsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetServiceRollout(
      google::api::servicemanagement::v1::GetServiceRolloutRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateServiceRollout(
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GenerateConfigReport(
      google::api::servicemanagement::v1::GenerateConfigReportRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency EnableService(
      google::api::servicemanagement::v1::EnableServiceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DisableService(
      google::api::servicemanagement::v1::DisableServiceRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ServiceManagerConnectionIdempotencyPolicy>
MakeDefaultServiceManagerConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultServiceManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement
}  // namespace cloud
}  // namespace google
