// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_SERVICE_MANAGER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_SERVICE_MANAGER_CONNECTION_H

#include "google/cloud/servicemanagement/internal/service_manager_retry_traits.h"
#include "google/cloud/servicemanagement/internal/service_manager_stub.h"
#include "google/cloud/servicemanagement/service_manager_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicemanagement {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ServiceManagerRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        servicemanagement_internal::ServiceManagerRetryTraits>;

using ServiceManagerLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        servicemanagement_internal::ServiceManagerRetryTraits>;

using ServiceManagerLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        servicemanagement_internal::ServiceManagerRetryTraits>;

class ServiceManagerConnection {
 public:
  virtual ~ServiceManagerConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::api::servicemanagement::v1::ManagedService>
  ListServices(google::api::servicemanagement::v1::ListServicesRequest request);

  virtual StatusOr<google::api::servicemanagement::v1::ManagedService>
  GetService(
      google::api::servicemanagement::v1::GetServiceRequest const& request);

  virtual future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(
      google::api::servicemanagement::v1::CreateServiceRequest const& request);

  virtual future<
      StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(
      google::api::servicemanagement::v1::DeleteServiceRequest const& request);

  virtual future<
      StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(
      google::api::servicemanagement::v1::UndeleteServiceRequest const&
          request);

  virtual StreamRange<google::api::Service> ListServiceConfigs(
      google::api::servicemanagement::v1::ListServiceConfigsRequest request);

  virtual StatusOr<google::api::Service> GetServiceConfig(
      google::api::servicemanagement::v1::GetServiceConfigRequest const&
          request);

  virtual StatusOr<google::api::Service> CreateServiceConfig(
      google::api::servicemanagement::v1::CreateServiceConfigRequest const&
          request);

  virtual future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
          request);

  virtual StreamRange<google::api::servicemanagement::v1::Rollout>
  ListServiceRollouts(
      google::api::servicemanagement::v1::ListServiceRolloutsRequest request);

  virtual StatusOr<google::api::servicemanagement::v1::Rollout>
  GetServiceRollout(
      google::api::servicemanagement::v1::GetServiceRolloutRequest const&
          request);

  virtual future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
          request);

  virtual StatusOr<
      google::api::servicemanagement::v1::GenerateConfigReportResponse>
  GenerateConfigReport(
      google::api::servicemanagement::v1::GenerateConfigReportRequest const&
          request);

  virtual future<
      StatusOr<google::api::servicemanagement::v1::EnableServiceResponse>>
  EnableService(
      google::api::servicemanagement::v1::EnableServiceRequest const& request);

  virtual future<
      StatusOr<google::api::servicemanagement::v1::DisableServiceResponse>>
  DisableService(
      google::api::servicemanagement::v1::DisableServiceRequest const& request);
};

std::shared_ptr<ServiceManagerConnection> MakeServiceManagerConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace servicemanagement_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<servicemanagement::ServiceManagerConnection>
MakeServiceManagerConnection(std::shared_ptr<ServiceManagerStub> stub,
                             Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_SERVICE_MANAGER_CONNECTION_H
