// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#include "google/cloud/servicemanagement/service_manager_connection.h"
#include "google/cloud/servicemanagement/internal/service_manager_connection_impl.h"
#include "google/cloud/servicemanagement/internal/service_manager_option_defaults.h"
#include "google/cloud/servicemanagement/internal/service_manager_stub_factory.h"
#include "google/cloud/servicemanagement/service_manager_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicemanagement {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceManagerConnection::~ServiceManagerConnection() = default;

StreamRange<google::api::servicemanagement::v1::ManagedService>
ServiceManagerConnection::ListServices(
    google::api::servicemanagement::v1::ListServicesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::api::servicemanagement::v1::ManagedService>>(
      std::move(request),
      [](google::api::servicemanagement::v1::ListServicesRequest const&) {
        return StatusOr<
            google::api::servicemanagement::v1::ListServicesResponse>{};
      },
      [](google::api::servicemanagement::v1::ListServicesResponse const&) {
        return std::vector<
            google::api::servicemanagement::v1::ManagedService>();
      });
}

StatusOr<google::api::servicemanagement::v1::ManagedService>
ServiceManagerConnection::GetService(
    google::api::servicemanagement::v1::GetServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
ServiceManagerConnection::CreateService(
    google::api::servicemanagement::v1::CreateServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::ManagedService>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
ServiceManagerConnection::DeleteService(
    google::api::servicemanagement::v1::DeleteServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
ServiceManagerConnection::UndeleteService(
    google::api::servicemanagement::v1::UndeleteServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::api::Service> ServiceManagerConnection::ListServiceConfigs(
    google::api::servicemanagement::v1::ListServiceConfigsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::api::Service>>(
      std::move(request),
      [](google::api::servicemanagement::v1::ListServiceConfigsRequest const&) {
        return StatusOr<
            google::api::servicemanagement::v1::ListServiceConfigsResponse>{};
      },
      [](google::api::servicemanagement::v1::
             ListServiceConfigsResponse const&) {
        return std::vector<google::api::Service>();
      });
}

StatusOr<google::api::Service> ServiceManagerConnection::GetServiceConfig(
    google::api::servicemanagement::v1::GetServiceConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::api::Service> ServiceManagerConnection::CreateServiceConfig(
    google::api::servicemanagement::v1::CreateServiceConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
ServiceManagerConnection::SubmitConfigSource(
    google::api::servicemanagement::v1::SubmitConfigSourceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::api::servicemanagement::v1::Rollout>
ServiceManagerConnection::ListServiceRollouts(
    google::api::servicemanagement::v1::ListServiceRolloutsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::api::servicemanagement::v1::Rollout>>(
      std::move(request),
      [](google::api::servicemanagement::v1::
             ListServiceRolloutsRequest const&) {
        return StatusOr<
            google::api::servicemanagement::v1::ListServiceRolloutsResponse>{};
      },
      [](google::api::servicemanagement::v1::
             ListServiceRolloutsResponse const&) {
        return std::vector<google::api::servicemanagement::v1::Rollout>();
      });
}

StatusOr<google::api::servicemanagement::v1::Rollout>
ServiceManagerConnection::GetServiceRollout(
    google::api::servicemanagement::v1::GetServiceRolloutRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::api::servicemanagement::v1::Rollout>>
ServiceManagerConnection::CreateServiceRollout(
    google::api::servicemanagement::v1::CreateServiceRolloutRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::Rollout>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
ServiceManagerConnection::GenerateConfigReport(
    google::api::servicemanagement::v1::GenerateConfigReportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::api::servicemanagement::v1::EnableServiceResponse>>
ServiceManagerConnection::EnableService(
    google::api::servicemanagement::v1::EnableServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::EnableServiceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::api::servicemanagement::v1::DisableServiceResponse>>
ServiceManagerConnection::DisableService(
    google::api::servicemanagement::v1::DisableServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::api::servicemanagement::v1::DisableServiceResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<ServiceManagerConnection> MakeServiceManagerConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 ServiceManagerPolicyOptionList>(options,
                                                                 __func__);
  options = servicemanagement_internal::ServiceManagerDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = servicemanagement_internal::CreateDefaultServiceManagerStub(
      background->cq(), options);
  return std::make_shared<
      servicemanagement_internal::ServiceManagerConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace servicemanagement_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<servicemanagement::ServiceManagerConnection>
MakeServiceManagerConnection(std::shared_ptr<ServiceManagerStub> stub,
                             Options options) {
  options = ServiceManagerDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      servicemanagement_internal::ServiceManagerConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_internal
}  // namespace cloud
}  // namespace google
