// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_SERVICE_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_SERVICE_MANAGER_CLIENT_H

#include "google/cloud/servicemanagement/service_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicemanagement {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// [Google Service Management
/// API](https://cloud.google.com/service-management/overview)
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ServiceManagerClient {
 public:
  explicit ServiceManagerClient(
      std::shared_ptr<ServiceManagerConnection> connection,
      Options options = {});
  ~ServiceManagerClient();

  //@{
  // @name Copy and move support
  ServiceManagerClient(ServiceManagerClient const&) = default;
  ServiceManagerClient& operator=(ServiceManagerClient const&) = default;
  ServiceManagerClient(ServiceManagerClient&&) = default;
  ServiceManagerClient& operator=(ServiceManagerClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ServiceManagerClient const& a,
                         ServiceManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ServiceManagerClient const& a,
                         ServiceManagerClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists managed services.
  ///
  /// Returns all public services. For authenticated users, also returns all
  /// services the calling user has "servicemanagement.services.get" permission
  /// for.
  ///
  /// **BETA:** If the caller specifies the `consumer_id`, it returns only the
  /// services enabled on the consumer. The `consumer_id` must have the format
  /// of "project:{PROJECT-ID}".
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::ListServicesRequest,google/api/servicemanagement/v1/servicemanager.proto#L284}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::ManagedService,google/api/servicemanagement/v1/resources.proto#L43}
  ///
  /// [google.api.servicemanagement.v1.ListServicesRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L284}
  /// [google.api.servicemanagement.v1.ManagedService]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L43}
  ///
  StreamRange<google::api::servicemanagement::v1::ManagedService> ListServices(
      google::api::servicemanagement::v1::ListServicesRequest request,
      Options options = {});

  ///
  /// Gets a managed service. Authentication is required unless the service is
  /// public.
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// `ServiceManager` overview for naming
  ///  requirements.  For example: `example.googleapis.com`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::ManagedService,google/api/servicemanagement/v1/resources.proto#L43}
  ///
  /// [google.api.servicemanagement.v1.GetServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L314}
  /// [google.api.servicemanagement.v1.ManagedService]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L43}
  ///
  StatusOr<google::api::servicemanagement::v1::ManagedService> GetService(
      std::string const& service_name, Options options = {});

  ///
  /// Gets a managed service. Authentication is required unless the service is
  /// public.
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::GetServiceRequest,google/api/servicemanagement/v1/servicemanager.proto#L314}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::ManagedService,google/api/servicemanagement/v1/resources.proto#L43}
  ///
  /// [google.api.servicemanagement.v1.GetServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L314}
  /// [google.api.servicemanagement.v1.ManagedService]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L43}
  ///
  StatusOr<google::api::servicemanagement::v1::ManagedService> GetService(
      google::api::servicemanagement::v1::GetServiceRequest const& request,
      Options options = {});

  ///
  /// Creates a new managed service.
  /// Please note one producer project can own no more than 20 services.
  ///
  /// Operation<response: ManagedService>
  ///
  /// @param service  Required. Initial values for the service resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::ManagedService,google/api/servicemanagement/v1/resources.proto#L43}
  ///
  /// [google.api.servicemanagement.v1.CreateServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L321}
  /// [google.api.servicemanagement.v1.ManagedService]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L43}
  ///
  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(
      google::api::servicemanagement::v1::ManagedService const& service,
      Options options = {});

  ///
  /// Creates a new managed service.
  /// Please note one producer project can own no more than 20 services.
  ///
  /// Operation<response: ManagedService>
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::CreateServiceRequest,google/api/servicemanagement/v1/servicemanager.proto#L321}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::ManagedService,google/api/servicemanagement/v1/resources.proto#L43}
  ///
  /// [google.api.servicemanagement.v1.CreateServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L321}
  /// [google.api.servicemanagement.v1.ManagedService]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L43}
  ///
  future<StatusOr<google::api::servicemanagement::v1::ManagedService>>
  CreateService(
      google::api::servicemanagement::v1::CreateServiceRequest const& request,
      Options options = {});

  ///
  /// Deletes a managed service. This method will change the service to the
  /// `Soft-Delete` state for 30 days. Within this period, service producers may
  /// call
  /// [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService]
  /// to restore the service. After 30 days, the service will be permanently
  /// deleted.
  ///
  /// Operation<response: google.protobuf.Empty>
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::OperationMetadata,google/api/servicemanagement/v1/resources.proto#L53}
  ///
  /// [google.api.servicemanagement.v1.DeleteServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L327}
  /// [google.api.servicemanagement.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L53}
  ///
  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(std::string const& service_name, Options options = {});

  ///
  /// Deletes a managed service. This method will change the service to the
  /// `Soft-Delete` state for 30 days. Within this period, service producers may
  /// call
  /// [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService]
  /// to restore the service. After 30 days, the service will be permanently
  /// deleted.
  ///
  /// Operation<response: google.protobuf.Empty>
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::DeleteServiceRequest,google/api/servicemanagement/v1/servicemanager.proto#L327}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::OperationMetadata,google/api/servicemanagement/v1/resources.proto#L53}
  ///
  /// [google.api.servicemanagement.v1.DeleteServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L327}
  /// [google.api.servicemanagement.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L53}
  ///
  future<StatusOr<google::api::servicemanagement::v1::OperationMetadata>>
  DeleteService(
      google::api::servicemanagement::v1::DeleteServiceRequest const& request,
      Options options = {});

  ///
  /// Revives a previously deleted managed service. The method restores the
  /// service using the configuration at the time the service was deleted.
  /// The target service must exist and must have been deleted within the
  /// last 30 days.
  ///
  /// Operation<response: UndeleteServiceResponse>
  ///
  /// @param service_name  Required. The name of the service. See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements. For example: `example.googleapis.com`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::UndeleteServiceResponse,google/api/servicemanagement/v1/servicemanager.proto#L341}
  ///
  /// [google.api.servicemanagement.v1.UndeleteServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L334}
  /// [google.api.servicemanagement.v1.UndeleteServiceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L341}
  ///
  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(std::string const& service_name, Options options = {});

  ///
  /// Revives a previously deleted managed service. The method restores the
  /// service using the configuration at the time the service was deleted.
  /// The target service must exist and must have been deleted within the
  /// last 30 days.
  ///
  /// Operation<response: UndeleteServiceResponse>
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::UndeleteServiceRequest,google/api/servicemanagement/v1/servicemanager.proto#L334}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::UndeleteServiceResponse,google/api/servicemanagement/v1/servicemanager.proto#L341}
  ///
  /// [google.api.servicemanagement.v1.UndeleteServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L334}
  /// [google.api.servicemanagement.v1.UndeleteServiceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L341}
  ///
  future<StatusOr<google::api::servicemanagement::v1::UndeleteServiceResponse>>
  UndeleteService(
      google::api::servicemanagement::v1::UndeleteServiceRequest const& request,
      Options options = {});

  ///
  /// Lists the history of the service configuration for a managed service,
  /// from the newest to the oldest.
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::Service,google/api/service.proto#L71}
  ///
  /// [google.api.servicemanagement.v1.ListServiceConfigsRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L375}
  /// [google.api.Service]:
  /// @googleapis_reference_link{google/api/service.proto#L71}
  ///
  StreamRange<google::api::Service> ListServiceConfigs(
      std::string const& service_name, Options options = {});

  ///
  /// Lists the history of the service configuration for a managed service,
  /// from the newest to the oldest.
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::ListServiceConfigsRequest,google/api/servicemanagement/v1/servicemanager.proto#L375}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::Service,google/api/service.proto#L71}
  ///
  /// [google.api.servicemanagement.v1.ListServiceConfigsRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L375}
  /// [google.api.Service]:
  /// @googleapis_reference_link{google/api/service.proto#L71}
  ///
  StreamRange<google::api::Service> ListServiceConfigs(
      google::api::servicemanagement::v1::ListServiceConfigsRequest request,
      Options options = {});

  ///
  /// Gets a service configuration (version) for a managed service.
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param config_id  Required. The id of the service configuration resource.
  ///  This field must be specified for the server to return all fields,
  ///  including `SourceInfo`.
  /// @param view  Specifies which parts of the Service Config should be
  /// returned in the
  ///  response.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::Service,google/api/service.proto#L71}
  ///
  /// [google.api.servicemanagement.v1.GetServiceConfigRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L347}
  /// [google.api.Service]:
  /// @googleapis_reference_link{google/api/service.proto#L71}
  ///
  StatusOr<google::api::Service> GetServiceConfig(
      std::string const& service_name, std::string const& config_id,
      google::api::servicemanagement::v1::GetServiceConfigRequest::ConfigView
          view,
      Options options = {});

  ///
  /// Gets a service configuration (version) for a managed service.
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::GetServiceConfigRequest,google/api/servicemanagement/v1/servicemanager.proto#L347}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::Service,google/api/service.proto#L71}
  ///
  /// [google.api.servicemanagement.v1.GetServiceConfigRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L347}
  /// [google.api.Service]:
  /// @googleapis_reference_link{google/api/service.proto#L71}
  ///
  StatusOr<google::api::Service> GetServiceConfig(
      google::api::servicemanagement::v1::GetServiceConfigRequest const&
          request,
      Options options = {});

  ///
  /// Creates a new service configuration (version) for a managed service.
  /// This method only stores the service configuration. To roll out the service
  /// configuration to backend systems please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent service configurations and ones referenced by
  /// existing rollouts are kept for each service. The rest will be deleted
  /// eventually.
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param service_config  Required. The service configuration resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::Service,google/api/service.proto#L71}
  ///
  /// [google.api.servicemanagement.v1.CreateServiceConfigRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L398}
  /// [google.api.Service]:
  /// @googleapis_reference_link{google/api/service.proto#L71}
  ///
  StatusOr<google::api::Service> CreateServiceConfig(
      std::string const& service_name,
      google::api::Service const& service_config, Options options = {});

  ///
  /// Creates a new service configuration (version) for a managed service.
  /// This method only stores the service configuration. To roll out the service
  /// configuration to backend systems please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent service configurations and ones referenced by
  /// existing rollouts are kept for each service. The rest will be deleted
  /// eventually.
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::CreateServiceConfigRequest,google/api/servicemanagement/v1/servicemanager.proto#L398}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::Service,google/api/service.proto#L71}
  ///
  /// [google.api.servicemanagement.v1.CreateServiceConfigRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L398}
  /// [google.api.Service]:
  /// @googleapis_reference_link{google/api/service.proto#L71}
  ///
  StatusOr<google::api::Service> CreateServiceConfig(
      google::api::servicemanagement::v1::CreateServiceConfigRequest const&
          request,
      Options options = {});

  ///
  /// Creates a new service configuration (version) for a managed service based
  /// on
  /// user-supplied configuration source files (for example: OpenAPI
  /// Specification). This method stores the source configurations as well as
  /// the generated service configuration. To rollout the service configuration
  /// to other services, please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent configuration sources and ones referenced by
  /// existing service configurtions are kept for each service. The rest will be
  /// deleted eventually.
  ///
  /// Operation<response: SubmitConfigSourceResponse>
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param config_source  Required. The source configuration for the service.
  /// @param validate_only  Optional. If set, this will result in the generation
  /// of a
  ///  `google.api.Service` configuration based on the `ConfigSource` provided,
  ///  but the generated config and the sources will NOT be persisted.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::SubmitConfigSourceResponse,google/api/servicemanagement/v1/servicemanager.proto#L423}
  ///
  /// [google.api.servicemanagement.v1.SubmitConfigSourceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L408}
  /// [google.api.servicemanagement.v1.SubmitConfigSourceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L423}
  ///
  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(
      std::string const& service_name,
      google::api::servicemanagement::v1::ConfigSource const& config_source,
      bool validate_only, Options options = {});

  ///
  /// Creates a new service configuration (version) for a managed service based
  /// on
  /// user-supplied configuration source files (for example: OpenAPI
  /// Specification). This method stores the source configurations as well as
  /// the generated service configuration. To rollout the service configuration
  /// to other services, please call
  /// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
  ///
  /// Only the 100 most recent configuration sources and ones referenced by
  /// existing service configurtions are kept for each service. The rest will be
  /// deleted eventually.
  ///
  /// Operation<response: SubmitConfigSourceResponse>
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::SubmitConfigSourceRequest,google/api/servicemanagement/v1/servicemanager.proto#L408}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::SubmitConfigSourceResponse,google/api/servicemanagement/v1/servicemanager.proto#L423}
  ///
  /// [google.api.servicemanagement.v1.SubmitConfigSourceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L408}
  /// [google.api.servicemanagement.v1.SubmitConfigSourceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L423}
  ///
  future<
      StatusOr<google::api::servicemanagement::v1::SubmitConfigSourceResponse>>
  SubmitConfigSource(
      google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
          request,
      Options options = {});

  ///
  /// Lists the history of the service configuration rollouts for a managed
  /// service, from the newest to the oldest.
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param filter  Required. Use `filter` to return subset of rollouts.
  ///  The following filters are supported:
  ///    -- To limit the results to only those in
  ///       status (google.api.servicemanagement.v1.RolloutStatus) 'SUCCESS',
  ///       use filter='status=SUCCESS'
  ///    -- To limit the results to those in
  ///       status (google.api.servicemanagement.v1.RolloutStatus) 'CANCELLED'
  ///       or 'FAILED', use filter='status=CANCELLED OR status=FAILED'
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::Rollout,google/api/servicemanagement/v1/resources.proto#L198}
  ///
  /// [google.api.servicemanagement.v1.ListServiceRolloutsRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L439}
  /// [google.api.servicemanagement.v1.Rollout]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L198}
  ///
  StreamRange<google::api::servicemanagement::v1::Rollout> ListServiceRollouts(
      std::string const& service_name, std::string const& filter,
      Options options = {});

  ///
  /// Lists the history of the service configuration rollouts for a managed
  /// service, from the newest to the oldest.
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::ListServiceRolloutsRequest,google/api/servicemanagement/v1/servicemanager.proto#L439}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::Rollout,google/api/servicemanagement/v1/resources.proto#L198}
  ///
  /// [google.api.servicemanagement.v1.ListServiceRolloutsRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L439}
  /// [google.api.servicemanagement.v1.Rollout]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L198}
  ///
  StreamRange<google::api::servicemanagement::v1::Rollout> ListServiceRollouts(
      google::api::servicemanagement::v1::ListServiceRolloutsRequest request,
      Options options = {});

  ///
  /// Gets a service configuration
  /// [rollout][google.api.servicemanagement.v1.Rollout].
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param rollout_id  Required. The id of the rollout resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::Rollout,google/api/servicemanagement/v1/resources.proto#L198}
  ///
  /// [google.api.servicemanagement.v1.GetServiceRolloutRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L472}
  /// [google.api.servicemanagement.v1.Rollout]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L198}
  ///
  StatusOr<google::api::servicemanagement::v1::Rollout> GetServiceRollout(
      std::string const& service_name, std::string const& rollout_id,
      Options options = {});

  ///
  /// Gets a service configuration
  /// [rollout][google.api.servicemanagement.v1.Rollout].
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::GetServiceRolloutRequest,google/api/servicemanagement/v1/servicemanager.proto#L472}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::Rollout,google/api/servicemanagement/v1/resources.proto#L198}
  ///
  /// [google.api.servicemanagement.v1.GetServiceRolloutRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L472}
  /// [google.api.servicemanagement.v1.Rollout]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L198}
  ///
  StatusOr<google::api::servicemanagement::v1::Rollout> GetServiceRollout(
      google::api::servicemanagement::v1::GetServiceRolloutRequest const&
          request,
      Options options = {});

  ///
  /// Creates a new service configuration rollout. Based on rollout, the
  /// Google Service Management will roll out the service configurations to
  /// different backend services. For example, the logging configuration will be
  /// pushed to Google Cloud Logging.
  ///
  /// Please note that any previous pending and running Rollouts and associated
  /// Operations will be automatically cancelled so that the latest Rollout will
  /// not be blocked by previous Rollouts.
  ///
  /// Only the 100 most recent (in any state) and the last 10 successful (if not
  /// already part of the set of 100 most recent) rollouts are kept for each
  /// service. The rest will be deleted eventually.
  ///
  /// Operation<response: Rollout>
  ///
  /// @param service_name  Required. The name of the service.  See the
  /// [overview](https://cloud.google.com/service-management/overview)
  ///  for naming requirements.  For example: `example.googleapis.com`.
  /// @param rollout  Required. The rollout resource. The `service_name` field
  /// is output only.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::Rollout,google/api/servicemanagement/v1/resources.proto#L198}
  ///
  /// [google.api.servicemanagement.v1.CreateServiceRolloutRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L429}
  /// [google.api.servicemanagement.v1.Rollout]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L198}
  ///
  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      std::string const& service_name,
      google::api::servicemanagement::v1::Rollout const& rollout,
      Options options = {});

  ///
  /// Creates a new service configuration rollout. Based on rollout, the
  /// Google Service Management will roll out the service configurations to
  /// different backend services. For example, the logging configuration will be
  /// pushed to Google Cloud Logging.
  ///
  /// Please note that any previous pending and running Rollouts and associated
  /// Operations will be automatically cancelled so that the latest Rollout will
  /// not be blocked by previous Rollouts.
  ///
  /// Only the 100 most recent (in any state) and the last 10 successful (if not
  /// already part of the set of 100 most recent) rollouts are kept for each
  /// service. The rest will be deleted eventually.
  ///
  /// Operation<response: Rollout>
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::CreateServiceRolloutRequest,google/api/servicemanagement/v1/servicemanager.proto#L429}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::Rollout,google/api/servicemanagement/v1/resources.proto#L198}
  ///
  /// [google.api.servicemanagement.v1.CreateServiceRolloutRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L429}
  /// [google.api.servicemanagement.v1.Rollout]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/resources.proto#L198}
  ///
  future<StatusOr<google::api::servicemanagement::v1::Rollout>>
  CreateServiceRollout(
      google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
          request,
      Options options = {});

  ///
  /// Generates and returns a report (errors, warnings and changes from
  /// existing configurations) associated with
  /// GenerateConfigReportRequest.new_value
  ///
  /// If GenerateConfigReportRequest.old_value is specified,
  /// GenerateConfigReportRequest will contain a single ChangeReport based on
  /// the comparison between GenerateConfigReportRequest.new_value and
  /// GenerateConfigReportRequest.old_value.
  /// If GenerateConfigReportRequest.old_value is not specified, this method
  /// will compare GenerateConfigReportRequest.new_value with the last pushed
  /// service configuration.
  ///
  /// @param new_config  Required. Service configuration for which we want to
  /// generate the report.
  ///  For this version of API, the supported types are
  ///  [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
  ///  [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
  ///  and [google.api.Service][google.api.Service]
  /// @param old_config  Optional. Service configuration against which the
  /// comparison will be done.
  ///  For this version of API, the supported types are
  ///  [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
  ///  [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
  ///  and [google.api.Service][google.api.Service]
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::GenerateConfigReportResponse,google/api/servicemanagement/v1/servicemanager.proto#L545}
  ///
  /// [google.api.servicemanagement.v1.GenerateConfigReportRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L528}
  /// [google.api.servicemanagement.v1.GenerateConfigReportResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L545}
  ///
  StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
  GenerateConfigReport(google::protobuf::Any const& new_config,
                       google::protobuf::Any const& old_config,
                       Options options = {});

  ///
  /// Generates and returns a report (errors, warnings and changes from
  /// existing configurations) associated with
  /// GenerateConfigReportRequest.new_value
  ///
  /// If GenerateConfigReportRequest.old_value is specified,
  /// GenerateConfigReportRequest will contain a single ChangeReport based on
  /// the comparison between GenerateConfigReportRequest.new_value and
  /// GenerateConfigReportRequest.old_value.
  /// If GenerateConfigReportRequest.old_value is not specified, this method
  /// will compare GenerateConfigReportRequest.new_value with the last pushed
  /// service configuration.
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::GenerateConfigReportRequest,google/api/servicemanagement/v1/servicemanager.proto#L528}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::GenerateConfigReportResponse,google/api/servicemanagement/v1/servicemanager.proto#L545}
  ///
  /// [google.api.servicemanagement.v1.GenerateConfigReportRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L528}
  /// [google.api.servicemanagement.v1.GenerateConfigReportResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L545}
  ///
  StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
  GenerateConfigReport(
      google::api::servicemanagement::v1::GenerateConfigReportRequest const&
          request,
      Options options = {});

  ///
  /// Enables a [service][google.api.servicemanagement.v1.ManagedService] for a
  /// project, so it can be used for the project. See [Cloud Auth
  /// Guide](https://cloud.google.com/docs/authentication) for more information.
  ///
  /// Operation<response: EnableServiceResponse>
  ///
  /// @param service_name  Required. Name of the service to enable. Specifying
  /// an unknown service name will
  ///  cause the request to fail.
  /// @param consumer_id  Required. The identity of consumer resource which
  /// service enablement will be
  ///  applied to.
  ///  The Google Service Management implementation accepts the following
  ///  forms:
  ///  - "project:<project_id>"
  ///  Note: this is made compatible with
  ///  google.api.servicecontrol.v1.Operation.consumer_id.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::EnableServiceResponse,google/api/servicemanagement/v1/servicemanager.proto#L500}
  ///
  /// [google.api.servicemanagement.v1.EnableServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L482}
  /// [google.api.servicemanagement.v1.EnableServiceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L500}
  ///
  future<StatusOr<google::api::servicemanagement::v1::EnableServiceResponse>>
  EnableService(std::string const& service_name, std::string const& consumer_id,
                Options options = {});

  ///
  /// Enables a [service][google.api.servicemanagement.v1.ManagedService] for a
  /// project, so it can be used for the project. See [Cloud Auth
  /// Guide](https://cloud.google.com/docs/authentication) for more information.
  ///
  /// Operation<response: EnableServiceResponse>
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::EnableServiceRequest,google/api/servicemanagement/v1/servicemanager.proto#L482}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::EnableServiceResponse,google/api/servicemanagement/v1/servicemanager.proto#L500}
  ///
  /// [google.api.servicemanagement.v1.EnableServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L482}
  /// [google.api.servicemanagement.v1.EnableServiceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L500}
  ///
  future<StatusOr<google::api::servicemanagement::v1::EnableServiceResponse>>
  EnableService(
      google::api::servicemanagement::v1::EnableServiceRequest const& request,
      Options options = {});

  ///
  /// Disables a [service][google.api.servicemanagement.v1.ManagedService] for a
  /// project, so it can no longer be be used for the project. It prevents
  /// accidental usage that may cause unexpected billing charges or security
  /// leaks.
  ///
  /// Operation<response: DisableServiceResponse>
  ///
  /// @param service_name  Required. Name of the service to disable. Specifying
  /// an unknown service name
  ///  will cause the request to fail.
  /// @param consumer_id  Required. The identity of consumer resource which
  /// service disablement will be
  ///  applied to.
  ///  The Google Service Management implementation accepts the following
  ///  forms:
  ///  - "project:<project_id>"
  ///  Note: this is made compatible with
  ///  google.api.servicecontrol.v1.Operation.consumer_id.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::DisableServiceResponse,google/api/servicemanagement/v1/servicemanager.proto#L523}
  ///
  /// [google.api.servicemanagement.v1.DisableServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L505}
  /// [google.api.servicemanagement.v1.DisableServiceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L523}
  ///
  future<StatusOr<google::api::servicemanagement::v1::DisableServiceResponse>>
  DisableService(std::string const& service_name,
                 std::string const& consumer_id, Options options = {});

  ///
  /// Disables a [service][google.api.servicemanagement.v1.ManagedService] for a
  /// project, so it can no longer be be used for the project. It prevents
  /// accidental usage that may cause unexpected billing charges or security
  /// leaks.
  ///
  /// Operation<response: DisableServiceResponse>
  ///
  /// @param request
  /// @googleapis_link{google::api::servicemanagement::v1::DisableServiceRequest,google/api/servicemanagement/v1/servicemanager.proto#L505}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::servicemanagement::v1::DisableServiceResponse,google/api/servicemanagement/v1/servicemanager.proto#L523}
  ///
  /// [google.api.servicemanagement.v1.DisableServiceRequest]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L505}
  /// [google.api.servicemanagement.v1.DisableServiceResponse]:
  /// @googleapis_reference_link{google/api/servicemanagement/v1/servicemanager.proto#L523}
  ///
  future<StatusOr<google::api::servicemanagement::v1::DisableServiceResponse>>
  DisableService(
      google::api::servicemanagement::v1::DisableServiceRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<ServiceManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEMANAGEMENT_SERVICE_MANAGER_CLIENT_H
