// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_REGISTRATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_REGISTRATION_CLIENT_H

#include "google/cloud/servicedirectory/registration_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service Directory API for registering services. It defines the following
/// resource model:
///
/// - The API has a collection of
/// [Namespace][google.cloud.servicedirectory.v1.Namespace]
/// resources, named `projects/*/locations/*/namespaces/*`.
///
/// - Each Namespace has a collection of
/// [Service][google.cloud.servicedirectory.v1.Service] resources, named
/// `projects/*/locations/*/namespaces/*/services/*`.
///
/// - Each Service has a collection of
/// [Endpoint][google.cloud.servicedirectory.v1.Endpoint]
/// resources, named
/// `projects/*/locations/*/namespaces/*/services/*/endpoints/*`.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class RegistrationServiceClient {
 public:
  explicit RegistrationServiceClient(
      std::shared_ptr<RegistrationServiceConnection> connection,
      Options options = {});
  ~RegistrationServiceClient();

  //@{
  // @name Copy and move support
  RegistrationServiceClient(RegistrationServiceClient const&) = default;
  RegistrationServiceClient& operator=(RegistrationServiceClient const&) =
      default;
  RegistrationServiceClient(RegistrationServiceClient&&) = default;
  RegistrationServiceClient& operator=(RegistrationServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(RegistrationServiceClient const& a,
                         RegistrationServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(RegistrationServiceClient const& a,
                         RegistrationServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a namespace, and returns the new Namespace.
  ///
  /// @param parent  Required. The resource name of the project and location the
  /// namespace
  ///  will be created in.
  /// @param namespace_  Required. A namespace with initial fields set.
  /// @param namespace_id  Required. The Resource ID must be 1-63 characters
  /// long, and comply with
  ///  <a href="https://www.ietf.org/rfc/rfc1035.txt"
  ///  target="_blank">RFC1035</a>. Specifically, the name must be 1-63
  ///  characters long and match the regular expression
  ///  `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first character must
  ///  be a lowercase letter, and all following characters must be a dash,
  ///  lowercase letter, or digit, except the last character, which cannot be a
  ///  dash.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.CreateNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L230}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Namespace> CreateNamespace(
      std::string const& parent,
      google::cloud::servicedirectory::v1::Namespace const& namespace_,
      std::string const& namespace_id, Options options = {});

  ///
  /// Creates a namespace, and returns the new Namespace.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::CreateNamespaceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L230}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.CreateNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L230}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Namespace> CreateNamespace(
      google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
          request,
      Options options = {});

  ///
  /// Lists all namespaces.
  ///
  /// @param parent  Required. The resource name of the project and location
  /// whose namespaces
  ///  we'd like to list.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.ListNamespacesRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L255}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StreamRange<google::cloud::servicedirectory::v1::Namespace> ListNamespaces(
      std::string const& parent, Options options = {});

  ///
  /// Lists all namespaces.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::ListNamespacesRequest,google/cloud/servicedirectory/v1/registration_service.proto#L255}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.ListNamespacesRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L255}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StreamRange<google::cloud::servicedirectory::v1::Namespace> ListNamespaces(
      google::cloud::servicedirectory::v1::ListNamespacesRequest request,
      Options options = {});

  ///
  /// Gets a namespace.
  ///
  /// @param name  Required. The name of the namespace to retrieve.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.GetNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L322}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Namespace> GetNamespace(
      std::string const& name, Options options = {});

  ///
  /// Gets a namespace.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::GetNamespaceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L322}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.GetNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L322}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Namespace> GetNamespace(
      google::cloud::servicedirectory::v1::GetNamespaceRequest const& request,
      Options options = {});

  ///
  /// Updates a namespace.
  ///
  /// @param namespace_  Required. The updated namespace.
  /// @param update_mask  Required. List of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.UpdateNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L334}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Namespace> UpdateNamespace(
      google::cloud::servicedirectory::v1::Namespace const& namespace_,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a namespace.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::UpdateNamespaceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L334}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Namespace,google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  /// [google.cloud.servicedirectory.v1.UpdateNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L334}
  /// [google.cloud.servicedirectory.v1.Namespace]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/namespace.proto#L35}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Namespace> UpdateNamespace(
      google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
          request,
      Options options = {});

  ///
  /// Deletes a namespace. This also deletes all services and endpoints in
  /// the namespace.
  ///
  /// @param name  Required. The name of the namespace to delete.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.servicedirectory.v1.DeleteNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L345}
  ///
  Status DeleteNamespace(std::string const& name, Options options = {});

  ///
  /// Deletes a namespace. This also deletes all services and endpoints in
  /// the namespace.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::DeleteNamespaceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L345}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.servicedirectory.v1.DeleteNamespaceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L345}
  ///
  Status DeleteNamespace(
      google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
          request,
      Options options = {});

  ///
  /// Creates a service, and returns the new Service.
  ///
  /// @param parent  Required. The resource name of the namespace this service
  /// will belong to.
  /// @param service  Required. A service  with initial fields set.
  /// @param service_id  Required. The Resource ID must be 1-63 characters long,
  /// and comply with
  ///  <a href="https://www.ietf.org/rfc/rfc1035.txt"
  ///  target="_blank">RFC1035</a>. Specifically, the name must be 1-63
  ///  characters long and match the regular expression
  ///  `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first character must
  ///  be a lowercase letter, and all following characters must be a dash,
  ///  lowercase letter, or digit, except the last character, which cannot be a
  ///  dash.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.CreateServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L357}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Service> CreateService(
      std::string const& parent,
      google::cloud::servicedirectory::v1::Service const& service,
      std::string const& service_id, Options options = {});

  ///
  /// Creates a service, and returns the new Service.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::CreateServiceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L357}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.CreateServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L357}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Service> CreateService(
      google::cloud::servicedirectory::v1::CreateServiceRequest const& request,
      Options options = {});

  ///
  /// Lists all services belonging to a namespace.
  ///
  /// @param parent  Required. The resource name of the namespace whose services
  /// we'd
  ///  like to list.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.ListServicesRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L381}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StreamRange<google::cloud::servicedirectory::v1::Service> ListServices(
      std::string const& parent, Options options = {});

  ///
  /// Lists all services belonging to a namespace.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::ListServicesRequest,google/cloud/servicedirectory/v1/registration_service.proto#L381}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.ListServicesRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L381}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StreamRange<google::cloud::servicedirectory::v1::Service> ListServices(
      google::cloud::servicedirectory::v1::ListServicesRequest request,
      Options options = {});

  ///
  /// Gets a service.
  ///
  /// @param name  Required. The name of the service to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.GetServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L442}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Service> GetService(
      std::string const& name, Options options = {});

  ///
  /// Gets a service.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::GetServiceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L442}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.GetServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L442}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Service> GetService(
      google::cloud::servicedirectory::v1::GetServiceRequest const& request,
      Options options = {});

  ///
  /// Updates a service.
  ///
  /// @param service  Required. The updated service.
  /// @param update_mask  Required. List of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.UpdateServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L454}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Service> UpdateService(
      google::cloud::servicedirectory::v1::Service const& service,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a service.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::UpdateServiceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L454}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Service,google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  /// [google.cloud.servicedirectory.v1.UpdateServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L454}
  /// [google.cloud.servicedirectory.v1.Service]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/service.proto#L37}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Service> UpdateService(
      google::cloud::servicedirectory::v1::UpdateServiceRequest const& request,
      Options options = {});

  ///
  /// Deletes a service. This also deletes all endpoints associated with
  /// the service.
  ///
  /// @param name  Required. The name of the service to delete.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.servicedirectory.v1.DeleteServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L465}
  ///
  Status DeleteService(std::string const& name, Options options = {});

  ///
  /// Deletes a service. This also deletes all endpoints associated with
  /// the service.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::DeleteServiceRequest,google/cloud/servicedirectory/v1/registration_service.proto#L465}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.servicedirectory.v1.DeleteServiceRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L465}
  ///
  Status DeleteService(
      google::cloud::servicedirectory::v1::DeleteServiceRequest const& request,
      Options options = {});

  ///
  /// Creates a endpoint, and returns the new Endpoint.
  ///
  /// @param parent  Required. The resource name of the service that this
  /// endpoint provides.
  /// @param endpoint  Required. A endpoint with initial fields set.
  /// @param endpoint_id  Required. The Resource ID must be 1-63 characters
  /// long, and comply with
  ///  <a href="https://www.ietf.org/rfc/rfc1035.txt"
  ///  target="_blank">RFC1035</a>. Specifically, the name must be 1-63
  ///  characters long and match the regular expression
  ///  `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?` which means the first character must
  ///  be a lowercase letter, and all following characters must be a dash,
  ///  lowercase letter, or digit, except the last character, which cannot be a
  ///  dash.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.CreateEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L477}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Endpoint> CreateEndpoint(
      std::string const& parent,
      google::cloud::servicedirectory::v1::Endpoint const& endpoint,
      std::string const& endpoint_id, Options options = {});

  ///
  /// Creates a endpoint, and returns the new Endpoint.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::CreateEndpointRequest,google/cloud/servicedirectory/v1/registration_service.proto#L477}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.CreateEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L477}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Endpoint> CreateEndpoint(
      google::cloud::servicedirectory::v1::CreateEndpointRequest const& request,
      Options options = {});

  ///
  /// Lists all endpoints.
  ///
  /// @param parent  Required. The resource name of the service whose endpoints
  /// we'd like to
  ///  list.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.ListEndpointsRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L501}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StreamRange<google::cloud::servicedirectory::v1::Endpoint> ListEndpoints(
      std::string const& parent, Options options = {});

  ///
  /// Lists all endpoints.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::ListEndpointsRequest,google/cloud/servicedirectory/v1/registration_service.proto#L501}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.ListEndpointsRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L501}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StreamRange<google::cloud::servicedirectory::v1::Endpoint> ListEndpoints(
      google::cloud::servicedirectory::v1::ListEndpointsRequest request,
      Options options = {});

  ///
  /// Gets a endpoint.
  ///
  /// @param name  Required. The name of the endpoint to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.GetEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L564}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Endpoint> GetEndpoint(
      std::string const& name, Options options = {});

  ///
  /// Gets a endpoint.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::GetEndpointRequest,google/cloud/servicedirectory/v1/registration_service.proto#L564}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.GetEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L564}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Endpoint> GetEndpoint(
      google::cloud::servicedirectory::v1::GetEndpointRequest const& request,
      Options options = {});

  ///
  /// Updates a endpoint.
  ///
  /// @param endpoint  Required. The updated endpoint.
  /// @param update_mask  Required. List of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.UpdateEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L576}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Endpoint> UpdateEndpoint(
      google::cloud::servicedirectory::v1::Endpoint const& endpoint,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a endpoint.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::UpdateEndpointRequest,google/cloud/servicedirectory/v1/registration_service.proto#L576}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::servicedirectory::v1::Endpoint,google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  /// [google.cloud.servicedirectory.v1.UpdateEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L576}
  /// [google.cloud.servicedirectory.v1.Endpoint]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/endpoint.proto#L34}
  ///
  StatusOr<google::cloud::servicedirectory::v1::Endpoint> UpdateEndpoint(
      google::cloud::servicedirectory::v1::UpdateEndpointRequest const& request,
      Options options = {});

  ///
  /// Deletes a endpoint.
  ///
  /// @param name  Required. The name of the endpoint to delete.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.servicedirectory.v1.DeleteEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L587}
  ///
  Status DeleteEndpoint(std::string const& name, Options options = {});

  ///
  /// Deletes a endpoint.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::servicedirectory::v1::DeleteEndpointRequest,google/cloud/servicedirectory/v1/registration_service.proto#L587}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.servicedirectory.v1.DeleteEndpointRequest]:
  /// @googleapis_reference_link{google/cloud/servicedirectory/v1/registration_service.proto#L587}
  ///
  Status DeleteEndpoint(
      google::cloud::servicedirectory::v1::DeleteEndpointRequest const& request,
      Options options = {});

  ///
  /// Gets the IAM Policy for a resource (namespace or service only).
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::GetIamPolicyRequest,google/iam/v1/iam_policy.proto#L113}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Sets the IAM Policy for a resource (namespace or service only).
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::SetIamPolicyRequest,google/iam/v1/iam_policy.proto#L98}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Tests IAM permissions for a resource (namespace or service only).
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::TestIamPermissionsRequest,google/iam/v1/iam_policy.proto#L126}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<RegistrationServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_REGISTRATION_CLIENT_H
