// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#include "google/cloud/servicedirectory/registration_client.h"
#include "google/cloud/servicedirectory/internal/registration_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegistrationServiceClient::RegistrationServiceClient(
    std::shared_ptr<RegistrationServiceConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          servicedirectory_internal::RegistrationServiceDefaultOptions(
              connection_->options()))) {}
RegistrationServiceClient::~RegistrationServiceClient() = default;

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::CreateNamespace(
    std::string const& parent,
    google::cloud::servicedirectory::v1::Namespace const& namespace_,
    std::string const& namespace_id, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::CreateNamespaceRequest request;
  request.set_parent(parent);
  *request.mutable_namespace_() = namespace_;
  request.set_namespace_id(namespace_id);
  return connection_->CreateNamespace(request);
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::CreateNamespace(
    google::cloud::servicedirectory::v1::CreateNamespaceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateNamespace(request);
}

StreamRange<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::ListNamespaces(std::string const& parent,
                                          Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::ListNamespacesRequest request;
  request.set_parent(parent);
  return connection_->ListNamespaces(request);
}

StreamRange<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::ListNamespaces(
    google::cloud::servicedirectory::v1::ListNamespacesRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListNamespaces(std::move(request));
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::GetNamespace(std::string const& name,
                                        Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::GetNamespaceRequest request;
  request.set_name(name);
  return connection_->GetNamespace(request);
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::GetNamespace(
    google::cloud::servicedirectory::v1::GetNamespaceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetNamespace(request);
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::UpdateNamespace(
    google::cloud::servicedirectory::v1::Namespace const& namespace_,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::UpdateNamespaceRequest request;
  *request.mutable_namespace_() = namespace_;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNamespace(request);
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceClient::UpdateNamespace(
    google::cloud::servicedirectory::v1::UpdateNamespaceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateNamespace(request);
}

Status RegistrationServiceClient::DeleteNamespace(std::string const& name,
                                                  Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::DeleteNamespaceRequest request;
  request.set_name(name);
  return connection_->DeleteNamespace(request);
}

Status RegistrationServiceClient::DeleteNamespace(
    google::cloud::servicedirectory::v1::DeleteNamespaceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteNamespace(request);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::CreateService(
    std::string const& parent,
    google::cloud::servicedirectory::v1::Service const& service,
    std::string const& service_id, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::CreateServiceRequest request;
  request.set_parent(parent);
  *request.mutable_service() = service;
  request.set_service_id(service_id);
  return connection_->CreateService(request);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::CreateService(
    google::cloud::servicedirectory::v1::CreateServiceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateService(request);
}

StreamRange<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::ListServices(std::string const& parent,
                                        Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::ListServicesRequest request;
  request.set_parent(parent);
  return connection_->ListServices(request);
}

StreamRange<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::ListServices(
    google::cloud::servicedirectory::v1::ListServicesRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListServices(std::move(request));
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::GetService(std::string const& name,
                                      Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::GetServiceRequest request;
  request.set_name(name);
  return connection_->GetService(request);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::GetService(
    google::cloud::servicedirectory::v1::GetServiceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetService(request);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::UpdateService(
    google::cloud::servicedirectory::v1::Service const& service,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::UpdateServiceRequest request;
  *request.mutable_service() = service;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateService(request);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceClient::UpdateService(
    google::cloud::servicedirectory::v1::UpdateServiceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateService(request);
}

Status RegistrationServiceClient::DeleteService(std::string const& name,
                                                Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::DeleteServiceRequest request;
  request.set_name(name);
  return connection_->DeleteService(request);
}

Status RegistrationServiceClient::DeleteService(
    google::cloud::servicedirectory::v1::DeleteServiceRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteService(request);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::CreateEndpoint(
    std::string const& parent,
    google::cloud::servicedirectory::v1::Endpoint const& endpoint,
    std::string const& endpoint_id, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::CreateEndpointRequest request;
  request.set_parent(parent);
  *request.mutable_endpoint() = endpoint;
  request.set_endpoint_id(endpoint_id);
  return connection_->CreateEndpoint(request);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::CreateEndpoint(
    google::cloud::servicedirectory::v1::CreateEndpointRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateEndpoint(request);
}

StreamRange<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::ListEndpoints(std::string const& parent,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::ListEndpointsRequest request;
  request.set_parent(parent);
  return connection_->ListEndpoints(request);
}

StreamRange<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::ListEndpoints(
    google::cloud::servicedirectory::v1::ListEndpointsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListEndpoints(std::move(request));
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::GetEndpoint(std::string const& name,
                                       Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::GetEndpointRequest request;
  request.set_name(name);
  return connection_->GetEndpoint(request);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::GetEndpoint(
    google::cloud::servicedirectory::v1::GetEndpointRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetEndpoint(request);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::UpdateEndpoint(
    google::cloud::servicedirectory::v1::Endpoint const& endpoint,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::UpdateEndpointRequest request;
  *request.mutable_endpoint() = endpoint;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEndpoint(request);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceClient::UpdateEndpoint(
    google::cloud::servicedirectory::v1::UpdateEndpointRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateEndpoint(request);
}

Status RegistrationServiceClient::DeleteEndpoint(std::string const& name,
                                                 Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::servicedirectory::v1::DeleteEndpointRequest request;
  request.set_name(name);
  return connection_->DeleteEndpoint(request);
}

Status RegistrationServiceClient::DeleteEndpoint(
    google::cloud::servicedirectory::v1::DeleteEndpointRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteEndpoint(request);
}

StatusOr<google::iam::v1::Policy> RegistrationServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> RegistrationServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
RegistrationServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory
}  // namespace cloud
}  // namespace google
