// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/lookup_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_LOOKUP_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_LOOKUP_CONNECTION_H

#include "google/cloud/servicedirectory/internal/lookup_retry_traits.h"
#include "google/cloud/servicedirectory/internal/lookup_stub.h"
#include "google/cloud/servicedirectory/lookup_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using LookupServiceRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        servicedirectory_internal::LookupServiceRetryTraits>;

using LookupServiceLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        servicedirectory_internal::LookupServiceRetryTraits>;

using LookupServiceLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        servicedirectory_internal::LookupServiceRetryTraits>;

class LookupServiceConnection {
 public:
  virtual ~LookupServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::servicedirectory::v1::ResolveServiceResponse>
  ResolveService(
      google::cloud::servicedirectory::v1::ResolveServiceRequest const&
          request);
};

std::shared_ptr<LookupServiceConnection> MakeLookupServiceConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace servicedirectory_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<servicedirectory::LookupServiceConnection>
MakeLookupServiceConnection(std::shared_ptr<LookupServiceStub> stub,
                            Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_LOOKUP_CONNECTION_H
