// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/lookup_service.proto

#include "google/cloud/servicedirectory/lookup_connection.h"
#include "google/cloud/servicedirectory/internal/lookup_connection_impl.h"
#include "google/cloud/servicedirectory/internal/lookup_option_defaults.h"
#include "google/cloud/servicedirectory/internal/lookup_stub_factory.h"
#include "google/cloud/servicedirectory/lookup_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LookupServiceConnection::~LookupServiceConnection() = default;

StatusOr<google::cloud::servicedirectory::v1::ResolveServiceResponse>
LookupServiceConnection::ResolveService(
    google::cloud::servicedirectory::v1::ResolveServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<LookupServiceConnection> MakeLookupServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 LookupServicePolicyOptionList>(options,
                                                                __func__);
  options = servicedirectory_internal::LookupServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = servicedirectory_internal::CreateDefaultLookupServiceStub(
      background->cq(), options);
  return std::make_shared<
      servicedirectory_internal::LookupServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace servicedirectory_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<servicedirectory::LookupServiceConnection>
MakeLookupServiceConnection(std::shared_ptr<LookupServiceStub> stub,
                            Options options) {
  options = LookupServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      servicedirectory_internal::LookupServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_internal
}  // namespace cloud
}  // namespace google
