// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#include "google/cloud/servicedirectory/internal/registration_connection_impl.h"
#include "google/cloud/servicedirectory/internal/registration_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegistrationServiceConnectionImpl::RegistrationServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<servicedirectory_internal::RegistrationServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          servicedirectory_internal::RegistrationServiceDefaultOptions(
              RegistrationServiceConnection::options()))) {}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceConnectionImpl::CreateNamespace(
    google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateNamespace(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
                 request) { return stub_->CreateNamespace(context, request); },
      request, __func__);
}

StreamRange<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceConnectionImpl::ListNamespaces(
    google::cloud::servicedirectory::v1::ListNamespacesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<servicedirectory::RegistrationServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListNamespaces(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::servicedirectory::v1::Namespace>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::servicedirectory::v1::ListNamespacesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::servicedirectory::v1::
                       ListNamespacesRequest const& request) {
              return stub->ListNamespaces(context, request);
            },
            r, function_name);
      },
      [](google::cloud::servicedirectory::v1::ListNamespacesResponse r) {
        std::vector<google::cloud::servicedirectory::v1::Namespace> result(
            r.namespaces().size());
        auto& messages = *r.mutable_namespaces();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceConnectionImpl::GetNamespace(
    google::cloud::servicedirectory::v1::GetNamespaceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetNamespace(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::GetNamespaceRequest const&
                 request) { return stub_->GetNamespace(context, request); },
      request, __func__);
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceConnectionImpl::UpdateNamespace(
    google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateNamespace(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
                 request) { return stub_->UpdateNamespace(context, request); },
      request, __func__);
}

Status RegistrationServiceConnectionImpl::DeleteNamespace(
    google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteNamespace(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
                 request) { return stub_->DeleteNamespace(context, request); },
      request, __func__);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceConnectionImpl::CreateService(
    google::cloud::servicedirectory::v1::CreateServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateService(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::CreateServiceRequest const&
                 request) { return stub_->CreateService(context, request); },
      request, __func__);
}

StreamRange<google::cloud::servicedirectory::v1::Service>
RegistrationServiceConnectionImpl::ListServices(
    google::cloud::servicedirectory::v1::ListServicesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<servicedirectory::RegistrationServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListServices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::servicedirectory::v1::Service>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::servicedirectory::v1::ListServicesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::servicedirectory::v1::ListServicesRequest const&
                    request) { return stub->ListServices(context, request); },
            r, function_name);
      },
      [](google::cloud::servicedirectory::v1::ListServicesResponse r) {
        std::vector<google::cloud::servicedirectory::v1::Service> result(
            r.services().size());
        auto& messages = *r.mutable_services();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceConnectionImpl::GetService(
    google::cloud::servicedirectory::v1::GetServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetService(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::GetServiceRequest const&
                 request) { return stub_->GetService(context, request); },
      request, __func__);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceConnectionImpl::UpdateService(
    google::cloud::servicedirectory::v1::UpdateServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateService(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::UpdateServiceRequest const&
                 request) { return stub_->UpdateService(context, request); },
      request, __func__);
}

Status RegistrationServiceConnectionImpl::DeleteService(
    google::cloud::servicedirectory::v1::DeleteServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteService(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::DeleteServiceRequest const&
                 request) { return stub_->DeleteService(context, request); },
      request, __func__);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceConnectionImpl::CreateEndpoint(
    google::cloud::servicedirectory::v1::CreateEndpointRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateEndpoint(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::CreateEndpointRequest const&
                 request) { return stub_->CreateEndpoint(context, request); },
      request, __func__);
}

StreamRange<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceConnectionImpl::ListEndpoints(
    google::cloud::servicedirectory::v1::ListEndpointsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<servicedirectory::RegistrationServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListEndpoints(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::servicedirectory::v1::Endpoint>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::servicedirectory::v1::ListEndpointsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::servicedirectory::v1::ListEndpointsRequest const&
                    request) { return stub->ListEndpoints(context, request); },
            r, function_name);
      },
      [](google::cloud::servicedirectory::v1::ListEndpointsResponse r) {
        std::vector<google::cloud::servicedirectory::v1::Endpoint> result(
            r.endpoints().size());
        auto& messages = *r.mutable_endpoints();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceConnectionImpl::GetEndpoint(
    google::cloud::servicedirectory::v1::GetEndpointRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetEndpoint(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::GetEndpointRequest const&
                 request) { return stub_->GetEndpoint(context, request); },
      request, __func__);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceConnectionImpl::UpdateEndpoint(
    google::cloud::servicedirectory::v1::UpdateEndpointRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateEndpoint(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::UpdateEndpointRequest const&
                 request) { return stub_->UpdateEndpoint(context, request); },
      request, __func__);
}

Status RegistrationServiceConnectionImpl::DeleteEndpoint(
    google::cloud::servicedirectory::v1::DeleteEndpointRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteEndpoint(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::DeleteEndpointRequest const&
                 request) { return stub_->DeleteEndpoint(context, request); },
      request, __func__);
}

StatusOr<google::iam::v1::Policy>
RegistrationServiceConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy>
RegistrationServiceConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
RegistrationServiceConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_internal
}  // namespace cloud
}  // namespace google
