// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicecontrol/v1/service_controller.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_SERVICE_CONTROLLER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_SERVICE_CONTROLLER_CONNECTION_H

#include "google/cloud/servicecontrol/internal/service_controller_retry_traits.h"
#include "google/cloud/servicecontrol/internal/service_controller_stub.h"
#include "google/cloud/servicecontrol/service_controller_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicecontrol {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ServiceControllerRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        servicecontrol_internal::ServiceControllerRetryTraits>;

using ServiceControllerLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        servicecontrol_internal::ServiceControllerRetryTraits>;

using ServiceControllerLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        servicecontrol_internal::ServiceControllerRetryTraits>;

class ServiceControllerConnection {
 public:
  virtual ~ServiceControllerConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::api::servicecontrol::v1::CheckResponse> Check(
      google::api::servicecontrol::v1::CheckRequest const& request);

  virtual StatusOr<google::api::servicecontrol::v1::ReportResponse> Report(
      google::api::servicecontrol::v1::ReportRequest const& request);
};

std::shared_ptr<ServiceControllerConnection> MakeServiceControllerConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicecontrol
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace servicecontrol_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<servicecontrol::ServiceControllerConnection>
MakeServiceControllerConnection(std::shared_ptr<ServiceControllerStub> stub,
                                Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicecontrol_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_SERVICE_CONTROLLER_CONNECTION_H
