// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTER_SECURITY_CENTER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTER_SECURITY_CENTER_CLIENT_H

#include "google/cloud/securitycenter/security_center_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/iam_updater.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace securitycenter {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// V1 APIs for Security Center service.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class SecurityCenterClient {
 public:
  explicit SecurityCenterClient(
      std::shared_ptr<SecurityCenterConnection> connection,
      Options options = {});
  ~SecurityCenterClient();

  //@{
  // @name Copy and move support
  SecurityCenterClient(SecurityCenterClient const&) = default;
  SecurityCenterClient& operator=(SecurityCenterClient const&) = default;
  SecurityCenterClient(SecurityCenterClient&&) = default;
  SecurityCenterClient& operator=(SecurityCenterClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(SecurityCenterClient const& a,
                         SecurityCenterClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(SecurityCenterClient const& a,
                         SecurityCenterClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
  /// parent can be either an organization, folder or project. The findings
  /// matched by the filter will be muted after the LRO is done.
  ///
  /// @param parent  Required. The parent, at which bulk action needs to be
  /// applied. Its format is
  ///  "organizations/[organization_id]", "folders/[folder_id]",
  ///  "projects/[project_id]".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::BulkMuteFindingsResponse,google/cloud/securitycenter/v1/securitycenter_service.proto#L525}
  ///
  /// [google.cloud.securitycenter.v1.BulkMuteFindingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L486}
  /// [google.cloud.securitycenter.v1.BulkMuteFindingsResponse]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L525}
  ///
  future<StatusOr<google::cloud::securitycenter::v1::BulkMuteFindingsResponse>>
  BulkMuteFindings(std::string const& parent, Options options = {});

  ///
  /// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
  /// parent can be either an organization, folder or project. The findings
  /// matched by the filter will be muted after the LRO is done.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::BulkMuteFindingsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L486}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::BulkMuteFindingsResponse,google/cloud/securitycenter/v1/securitycenter_service.proto#L525}
  ///
  /// [google.cloud.securitycenter.v1.BulkMuteFindingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L486}
  /// [google.cloud.securitycenter.v1.BulkMuteFindingsResponse]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L525}
  ///
  future<StatusOr<google::cloud::securitycenter::v1::BulkMuteFindingsResponse>>
  BulkMuteFindings(
      google::cloud::securitycenter::v1::BulkMuteFindingsRequest const& request,
      Options options = {});

  ///
  /// Creates a source.
  ///
  /// @param parent  Required. Resource name of the new source's parent. Its
  /// format should be
  ///  "organizations/[organization_id]".
  /// @param source  Required. The Source being created, only the display_name
  /// and description will be
  ///  used. All other fields will be ignored.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.CreateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L595}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::Source> CreateSource(
      std::string const& parent,
      google::cloud::securitycenter::v1::Source const& source,
      Options options = {});

  ///
  /// Creates a source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::CreateSourceRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L595}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.CreateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L595}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::Source> CreateSource(
      google::cloud::securitycenter::v1::CreateSourceRequest const& request,
      Options options = {});

  ///
  /// Creates a finding. The corresponding source must exist for finding
  /// creation to succeed.
  ///
  /// @param parent  Required. Resource name of the new finding's parent. Its
  /// format should be
  ///  "organizations/[organization_id]/sources/[source_id]".
  /// @param finding_id  Required. Unique identifier provided by the client
  /// within the parent scope.
  ///  It must be alphanumeric and less than or equal to 32 characters and
  ///  greater than 0 characters in length.
  /// @param finding  Required. The Finding being created. The name and
  /// security_marks will be ignored as
  ///  they are both output only fields on this resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.CreateFindingRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L530}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> CreateFinding(
      std::string const& parent, std::string const& finding_id,
      google::cloud::securitycenter::v1::Finding const& finding,
      Options options = {});

  ///
  /// Creates a finding. The corresponding source must exist for finding
  /// creation to succeed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::CreateFindingRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L530}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.CreateFindingRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L530}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> CreateFinding(
      google::cloud::securitycenter::v1::CreateFindingRequest const& request,
      Options options = {});

  ///
  /// Creates a mute config.
  ///
  /// @param parent  Required. Resource name of the new mute configs's parent.
  /// Its format is
  ///  "organizations/[organization_id]", "folders/[folder_id]", or
  ///  "projects/[project_id]".
  /// @param mute_config  Required. The mute config being created.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.CreateMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L551}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StatusOr<google::cloud::securitycenter::v1::MuteConfig> CreateMuteConfig(
      std::string const& parent,
      google::cloud::securitycenter::v1::MuteConfig const& mute_config,
      Options options = {});

  ///
  /// Creates a mute config.
  ///
  /// @param parent  Required. Resource name of the new mute configs's parent.
  /// Its format is
  ///  "organizations/[organization_id]", "folders/[folder_id]", or
  ///  "projects/[project_id]".
  /// @param mute_config  Required. The mute config being created.
  /// @param mute_config_id  Required. Unique identifier provided by the client
  /// within the parent scope.
  ///  It must consist of lower case letters, numbers, and hyphen, with the
  ///  first character a letter, the last a letter or a number, and a 63
  ///  character maximum.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.CreateMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L551}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StatusOr<google::cloud::securitycenter::v1::MuteConfig> CreateMuteConfig(
      std::string const& parent,
      google::cloud::securitycenter::v1::MuteConfig const& mute_config,
      std::string const& mute_config_id, Options options = {});

  ///
  /// Creates a mute config.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::CreateMuteConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L551}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.CreateMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L551}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StatusOr<google::cloud::securitycenter::v1::MuteConfig> CreateMuteConfig(
      google::cloud::securitycenter::v1::CreateMuteConfigRequest const& request,
      Options options = {});

  ///
  /// Creates a notification config.
  ///
  /// @param parent  Required. Resource name of the new notification config's
  /// parent. Its format is
  ///  "organizations/[organization_id]".
  /// @param config_id  Required.
  ///  Unique identifier provided by the client within the parent scope.
  ///  It must be between 1 and 128 characters, and contains alphanumeric
  ///  characters, underscores or hyphens only.
  /// @param notification_config  Required. The notification config being
  /// created. The name and the service account
  ///  will be ignored as they are both output only fields on this resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.CreateNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L573}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  CreateNotificationConfig(
      std::string const& parent, std::string const& config_id,
      google::cloud::securitycenter::v1::NotificationConfig const&
          notification_config,
      Options options = {});

  ///
  /// Creates a notification config.
  ///
  /// @param parent  Required. Resource name of the new notification config's
  /// parent. Its format is
  ///  "organizations/[organization_id]".
  /// @param notification_config  Required. The notification config being
  /// created. The name and the service account
  ///  will be ignored as they are both output only fields on this resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.CreateNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L573}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  CreateNotificationConfig(
      std::string const& parent,
      google::cloud::securitycenter::v1::NotificationConfig const&
          notification_config,
      Options options = {});

  ///
  /// Creates a notification config.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::CreateNotificationConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L573}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.CreateNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L573}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  CreateNotificationConfig(
      google::cloud::securitycenter::v1::CreateNotificationConfigRequest const&
          request,
      Options options = {});

  ///
  /// Deletes an existing mute config.
  ///
  /// @param name  Required. Name of the mute config to delete. Its format is
  ///  organizations/{organization}/muteConfigs/{config_id},
  ///  folders/{folder}/muteConfigs/{config_id}, or
  ///  projects/{project}/muteConfigs/{config_id}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.securitycenter.v1.DeleteMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L611}
  ///
  Status DeleteMuteConfig(std::string const& name, Options options = {});

  ///
  /// Deletes an existing mute config.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::DeleteMuteConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L611}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.securitycenter.v1.DeleteMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L611}
  ///
  Status DeleteMuteConfig(
      google::cloud::securitycenter::v1::DeleteMuteConfigRequest const& request,
      Options options = {});

  ///
  /// Deletes a notification config.
  ///
  /// @param name  Required. Name of the notification config to delete. Its
  /// format is
  ///  "organizations/[organization_id]/notificationConfigs/[config_id]".
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.securitycenter.v1.DeleteNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L625}
  ///
  Status DeleteNotificationConfig(std::string const& name,
                                  Options options = {});

  ///
  /// Deletes a notification config.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::DeleteNotificationConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L625}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.securitycenter.v1.DeleteNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L625}
  ///
  Status DeleteNotificationConfig(
      google::cloud::securitycenter::v1::DeleteNotificationConfigRequest const&
          request,
      Options options = {});

  ///
  /// Gets the access control policy on the specified Source.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(std::string const& resource,
                                                 Options options = {});

  ///
  /// Gets the access control policy on the specified Source.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::GetIamPolicyRequest,google/iam/v1/iam_policy.proto#L113}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Gets a mute config.
  ///
  /// @param name  Required. Name of the mute config to retrieve. Its format is
  ///  organizations/{organization}/muteConfigs/{config_id},
  ///  folders/{folder}/muteConfigs/{config_id}, or
  ///  projects/{project}/muteConfigs/{config_id}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.GetMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L637}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StatusOr<google::cloud::securitycenter::v1::MuteConfig> GetMuteConfig(
      std::string const& name, Options options = {});

  ///
  /// Gets a mute config.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::GetMuteConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L637}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.GetMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L637}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StatusOr<google::cloud::securitycenter::v1::MuteConfig> GetMuteConfig(
      google::cloud::securitycenter::v1::GetMuteConfigRequest const& request,
      Options options = {});

  ///
  /// Gets a notification config.
  ///
  /// @param name  Required. Name of the notification config to get. Its format
  /// is
  ///  "organizations/[organization_id]/notificationConfigs/[config_id]".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.GetNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L651}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  GetNotificationConfig(std::string const& name, Options options = {});

  ///
  /// Gets a notification config.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::GetNotificationConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L651}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.GetNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L651}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  GetNotificationConfig(
      google::cloud::securitycenter::v1::GetNotificationConfigRequest const&
          request,
      Options options = {});

  ///
  /// Gets the settings for an organization.
  ///
  /// @param name  Required. Name of the organization to get organization
  /// settings for. Its format is
  ///  "organizations/[organization_id]/organizationSettings".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::OrganizationSettings,google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  /// [google.cloud.securitycenter.v1.GetOrganizationSettingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L663}
  /// [google.cloud.securitycenter.v1.OrganizationSettings]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
  GetOrganizationSettings(std::string const& name, Options options = {});

  ///
  /// Gets the settings for an organization.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::GetOrganizationSettingsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L663}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::OrganizationSettings,google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  /// [google.cloud.securitycenter.v1.GetOrganizationSettingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L663}
  /// [google.cloud.securitycenter.v1.OrganizationSettings]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
  GetOrganizationSettings(
      google::cloud::securitycenter::v1::GetOrganizationSettingsRequest const&
          request,
      Options options = {});

  ///
  /// Gets a source.
  ///
  /// @param name  Required. Relative resource name of the source. Its format is
  ///  "organizations/[organization_id]/source/[source_id]".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.GetSourceRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L675}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::Source> GetSource(
      std::string const& name, Options options = {});

  ///
  /// Gets a source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::GetSourceRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L675}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.GetSourceRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L675}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::Source> GetSource(
      google::cloud::securitycenter::v1::GetSourceRequest const& request,
      Options options = {});

  ///
  /// Filters an organization's assets and  groups them by their specified
  /// properties.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::GroupAssetsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L687}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::GroupResult,google/cloud/securitycenter/v1/securitycenter_service.proto#L1008}
  ///
  /// [google.cloud.securitycenter.v1.GroupAssetsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L687}
  /// [google.cloud.securitycenter.v1.GroupResult]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1008}
  ///
  StreamRange<google::cloud::securitycenter::v1::GroupResult> GroupAssets(
      google::cloud::securitycenter::v1::GroupAssetsRequest request,
      Options options = {});

  ///
  /// Filters an organization or source's findings and  groups them by their
  /// specified properties.
  ///
  /// To group across all sources provide a `-` as the source id.
  /// Example: /v1/organizations/{organization_id}/sources/-/findings,
  /// /v1/folders/{folder_id}/sources/-/findings,
  /// /v1/projects/{project_id}/sources/-/findings
  ///
  /// @param parent  Required. Name of the source to groupBy. Its format is
  ///  "organizations/[organization_id]/sources/[source_id]",
  ///  folders/[folder_id]/sources/[source_id], or
  ///  projects/[project_id]/sources/[source_id]. To groupBy across all sources
  ///  provide a source_id of `-`. For example:
  ///  organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-,
  ///  or projects/{project_id}/sources/-
  /// @param group_by  Required. Expression that defines what assets fields to
  /// use for grouping (including
  ///  `state_change`). The string value should follow SQL syntax: comma
  ///  separated list of fields. For example: "parent,resource_name". The
  ///  following fields are supported:
  ///  * resource_name
  ///  * category
  ///  * state
  ///  * parent
  ///  * severity
  ///  The following fields are supported when compare_duration is set:
  ///  * state_change
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::GroupResult,google/cloud/securitycenter/v1/securitycenter_service.proto#L1008}
  ///
  /// [google.cloud.securitycenter.v1.GroupFindingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L846}
  /// [google.cloud.securitycenter.v1.GroupResult]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1008}
  ///
  StreamRange<google::cloud::securitycenter::v1::GroupResult> GroupFindings(
      std::string const& parent, std::string const& group_by,
      Options options = {});

  ///
  /// Filters an organization or source's findings and  groups them by their
  /// specified properties.
  ///
  /// To group across all sources provide a `-` as the source id.
  /// Example: /v1/organizations/{organization_id}/sources/-/findings,
  /// /v1/folders/{folder_id}/sources/-/findings,
  /// /v1/projects/{project_id}/sources/-/findings
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::GroupFindingsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L846}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::GroupResult,google/cloud/securitycenter/v1/securitycenter_service.proto#L1008}
  ///
  /// [google.cloud.securitycenter.v1.GroupFindingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L846}
  /// [google.cloud.securitycenter.v1.GroupResult]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1008}
  ///
  StreamRange<google::cloud::securitycenter::v1::GroupResult> GroupFindings(
      google::cloud::securitycenter::v1::GroupFindingsRequest request,
      Options options = {});

  ///
  /// Lists an organization's assets.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::ListAssetsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1117}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::ListAssetsResponse::ListAssetsResult,google/cloud/securitycenter/v1/securitycenter_service.proto#L1265}
  ///
  /// [google.cloud.securitycenter.v1.ListAssetsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1117}
  /// [google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1265}
  ///
  StreamRange<
      google::cloud::securitycenter::v1::ListAssetsResponse::ListAssetsResult>
  ListAssets(google::cloud::securitycenter::v1::ListAssetsRequest request,
             Options options = {});

  ///
  /// Lists an organization or source's findings.
  ///
  /// To list across all sources provide a `-` as the source id.
  /// Example: /v1/organizations/{organization_id}/sources/-/findings
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::ListFindingsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1308}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::ListFindingsResponse::ListFindingsResult,google/cloud/securitycenter/v1/securitycenter_service.proto#L1461}
  ///
  /// [google.cloud.securitycenter.v1.ListFindingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1308}
  /// [google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1461}
  ///
  StreamRange<google::cloud::securitycenter::v1::ListFindingsResponse::
                  ListFindingsResult>
  ListFindings(google::cloud::securitycenter::v1::ListFindingsRequest request,
               Options options = {});

  ///
  /// Lists mute configs.
  ///
  /// @param parent  Required. The parent, which owns the collection of mute
  /// configs. Its format is
  ///  "organizations/[organization_id]", "folders/[folder_id]",
  ///  "projects/[project_id]".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.ListMuteConfigsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1018}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StreamRange<google::cloud::securitycenter::v1::MuteConfig> ListMuteConfigs(
      std::string const& parent, Options options = {});

  ///
  /// Lists mute configs.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::ListMuteConfigsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1018}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.ListMuteConfigsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1018}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StreamRange<google::cloud::securitycenter::v1::MuteConfig> ListMuteConfigs(
      google::cloud::securitycenter::v1::ListMuteConfigsRequest request,
      Options options = {});

  ///
  /// Lists notification configs.
  ///
  /// @param parent  Required. Name of the organization to list notification
  /// configs.
  ///  Its format is "organizations/[organization_id]".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.ListNotificationConfigsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1054}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StreamRange<google::cloud::securitycenter::v1::NotificationConfig>
  ListNotificationConfigs(std::string const& parent, Options options = {});

  ///
  /// Lists notification configs.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::ListNotificationConfigsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1054}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.ListNotificationConfigsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1054}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StreamRange<google::cloud::securitycenter::v1::NotificationConfig>
  ListNotificationConfigs(
      google::cloud::securitycenter::v1::ListNotificationConfigsRequest request,
      Options options = {});

  ///
  /// Lists all sources belonging to an organization.
  ///
  /// @param parent  Required. Resource name of the parent of sources to list.
  /// Its format should be
  ///  "organizations/[organization_id], folders/[folder_id], or
  ///  projects/[project_id]".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.ListSourcesRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1085}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StreamRange<google::cloud::securitycenter::v1::Source> ListSources(
      std::string const& parent, Options options = {});

  ///
  /// Lists all sources belonging to an organization.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::ListSourcesRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1085}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.ListSourcesRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1085}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StreamRange<google::cloud::securitycenter::v1::Source> ListSources(
      google::cloud::securitycenter::v1::ListSourcesRequest request,
      Options options = {});

  ///
  /// Runs asset discovery. The discovery is tracked with a long-running
  /// operation.
  ///
  /// This API can only be called with limited frequency for an organization. If
  /// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
  /// error.
  ///
  /// @param parent  Required. Name of the organization to run asset discovery
  /// for. Its format is
  ///  "organizations/[organization_id]".
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::RunAssetDiscoveryResponse,google/cloud/securitycenter/v1/run_asset_discovery_response.proto#L30}
  ///
  /// [google.cloud.securitycenter.v1.RunAssetDiscoveryRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1585}
  /// [google.cloud.securitycenter.v1.RunAssetDiscoveryResponse]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/run_asset_discovery_response.proto#L30}
  ///
  future<StatusOr<google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>>
  RunAssetDiscovery(std::string const& parent, Options options = {});

  ///
  /// Runs asset discovery. The discovery is tracked with a long-running
  /// operation.
  ///
  /// This API can only be called with limited frequency for an organization. If
  /// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
  /// error.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::RunAssetDiscoveryRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1585}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::RunAssetDiscoveryResponse,google/cloud/securitycenter/v1/run_asset_discovery_response.proto#L30}
  ///
  /// [google.cloud.securitycenter.v1.RunAssetDiscoveryRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1585}
  /// [google.cloud.securitycenter.v1.RunAssetDiscoveryResponse]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/run_asset_discovery_response.proto#L30}
  ///
  future<StatusOr<google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>>
  RunAssetDiscovery(
      google::cloud::securitycenter::v1::RunAssetDiscoveryRequest const&
          request,
      Options options = {});

  ///
  /// Updates the state of a finding.
  ///
  /// @param name  Required. The relative resource name of the finding. See:
  ///  https://cloud.google.com/apis/design/resource_names#relative_resource_name
  ///  Example:
  ///  "organizations/{organization_id}/sources/{source_id}/finding/{finding_id}".
  /// @param state  Required. The desired State of the finding.
  /// @param start_time  Required. The time at which the updated state takes
  /// effect.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.SetFindingStateRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1546}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> SetFindingState(
      std::string const& name,
      google::cloud::securitycenter::v1::Finding::State state,
      google::protobuf::Timestamp const& start_time, Options options = {});

  ///
  /// Updates the state of a finding.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::SetFindingStateRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1546}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.SetFindingStateRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1546}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> SetFindingState(
      google::cloud::securitycenter::v1::SetFindingStateRequest const& request,
      Options options = {});

  ///
  /// Updates the mute state of a finding.
  ///
  /// @param name  Required. The relative resource name of the finding. See:
  ///  https://cloud.google.com/apis/design/resource_names#relative_resource_name
  ///  Example:
  ///  "organizations/{organization_id}/sources/{source_id}/finding/{finding_id}",
  ///  "folders/{folder_id}/sources/{source_id}/finding/{finding_id}",
  ///  "projects/{project_id}/sources/{source_id}/finding/{finding_id}".
  /// @param mute  Required. The desired state of the Mute.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.SetMuteRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1566}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> SetMute(
      std::string const& name,
      google::cloud::securitycenter::v1::Finding::Mute mute,
      Options options = {});

  ///
  /// Updates the mute state of a finding.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::SetMuteRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1566}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.SetMuteRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1566}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> SetMute(
      google::cloud::securitycenter::v1::SetMuteRequest const& request,
      Options options = {});

  ///
  /// Sets the access control policy on the specified Source.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// specified.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param policy  REQUIRED: The complete policy to be applied to the
  /// `resource`. The size of
  ///  the policy is limited to a few 10s of KB. An empty policy is a
  ///  valid policy but certain Cloud Platform services (such as Projects)
  ///  might reject them.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      std::string const& resource, google::iam::v1::Policy const& policy,
      Options options = {});

  /**
   * Updates the IAM policy for @p resource using an optimistic concurrency
   * control loop.
   *
   * The loop fetches the current policy for @p resource, and passes it to @p
   * updater, which should return the new policy. This new policy should use the
   * current etag so that the read-modify-write cycle can detect races and rerun
   * the update when there is a mismatch. If the new policy does not have an
   * etag, the existing policy will be blindly overwritten. If @p updater does
   * not yield a policy, the control loop is terminated and kCancelled is
   * returned.
   *
   * @param resource  Required. The resource for which the policy is being
   * specified. See the operation documentation for the appropriate value for
   * this field.
   * @param updater  Required. Functor to map the current policy to a new one.
   * @param options  Optional. Options to control the loop. Expected options
   * are:
   *       - `SecurityCenterBackoffPolicyOption`
   * @return google::iam::v1::Policy
   */
  StatusOr<google::iam::v1::Policy> SetIamPolicy(std::string const& resource,
                                                 IamUpdater const& updater,
                                                 Options options = {});

  ///
  /// Sets the access control policy on the specified Source.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::SetIamPolicyRequest,google/iam/v1/iam_policy.proto#L98}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Returns the permissions that a caller has on the specified source.
  ///
  /// @param resource  REQUIRED: The resource for which the policy detail is
  /// being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param permissions  The set of permissions to check for the `resource`.
  /// Permissions with
  ///  wildcards (such as '*' or 'storage.*') are not allowed. For more
  ///  information see
  ///  [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      std::string const& resource, std::vector<std::string> const& permissions,
      Options options = {});

  ///
  /// Returns the permissions that a caller has on the specified source.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::TestIamPermissionsRequest,google/iam/v1/iam_policy.proto#L126}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options options = {});

  ///
  /// Updates external system. This is for a given finding.
  ///
  /// @param external_system  Required. The external system resource to update.
  /// @param update_mask  The FieldMask to use when updating the external system
  /// resource.
  ///  If empty all mutable fields will be updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::ExternalSystem,google/cloud/securitycenter/v1/external_system.proto#L32}
  ///
  /// [google.cloud.securitycenter.v1.UpdateExternalSystemRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1597}
  /// [google.cloud.securitycenter.v1.ExternalSystem]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/external_system.proto#L32}
  ///
  StatusOr<google::cloud::securitycenter::v1::ExternalSystem>
  UpdateExternalSystem(
      google::cloud::securitycenter::v1::ExternalSystem const& external_system,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates external system. This is for a given finding.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::UpdateExternalSystemRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1597}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::ExternalSystem,google/cloud/securitycenter/v1/external_system.proto#L32}
  ///
  /// [google.cloud.securitycenter.v1.UpdateExternalSystemRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1597}
  /// [google.cloud.securitycenter.v1.ExternalSystem]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/external_system.proto#L32}
  ///
  StatusOr<google::cloud::securitycenter::v1::ExternalSystem>
  UpdateExternalSystem(
      google::cloud::securitycenter::v1::UpdateExternalSystemRequest const&
          request,
      Options options = {});

  ///
  /// Creates or updates a finding. The corresponding source must exist for a
  /// finding creation to succeed.
  ///
  /// @param finding  Required. The finding resource to update or create if it
  /// does not already exist.
  ///  parent, security_marks, and update_time will be ignored.
  ///  In the case of creation, the finding id portion of the name must be
  ///  alphanumeric and less than or equal to 32 characters and greater than 0
  ///  characters in length.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.UpdateFindingRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1608}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> UpdateFinding(
      google::cloud::securitycenter::v1::Finding const& finding,
      Options options = {});

  ///
  /// Creates or updates a finding. The corresponding source must exist for a
  /// finding creation to succeed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::UpdateFindingRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1608}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Finding,google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  /// [google.cloud.securitycenter.v1.UpdateFindingRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1608}
  /// [google.cloud.securitycenter.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/finding.proto#L43}
  ///
  StatusOr<google::cloud::securitycenter::v1::Finding> UpdateFinding(
      google::cloud::securitycenter::v1::UpdateFindingRequest const& request,
      Options options = {});

  ///
  /// Updates a mute config.
  ///
  /// @param mute_config  Required. The mute config being updated.
  /// @param update_mask  The list of fields to be updated.
  ///  If empty all mutable fields will be updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.UpdateMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1628}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StatusOr<google::cloud::securitycenter::v1::MuteConfig> UpdateMuteConfig(
      google::cloud::securitycenter::v1::MuteConfig const& mute_config,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a mute config.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::UpdateMuteConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1628}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::MuteConfig,google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  /// [google.cloud.securitycenter.v1.UpdateMuteConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1628}
  /// [google.cloud.securitycenter.v1.MuteConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/mute_config.proto#L34}
  ///
  StatusOr<google::cloud::securitycenter::v1::MuteConfig> UpdateMuteConfig(
      google::cloud::securitycenter::v1::UpdateMuteConfigRequest const& request,
      Options options = {});

  ///
  ///
  /// Updates a notification config. The following update
  /// fields are allowed: description, pubsub_topic, streaming_config.filter
  ///
  /// @param notification_config  Required. The notification config to update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.UpdateNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1638}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  UpdateNotificationConfig(
      google::cloud::securitycenter::v1::NotificationConfig const&
          notification_config,
      Options options = {});

  ///
  ///
  /// Updates a notification config. The following update
  /// fields are allowed: description, pubsub_topic, streaming_config.filter
  ///
  /// @param notification_config  Required. The notification config to update.
  /// @param update_mask  The FieldMask to use when updating the notification
  /// config.
  ///  If empty all mutable fields will be updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.UpdateNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1638}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  UpdateNotificationConfig(
      google::cloud::securitycenter::v1::NotificationConfig const&
          notification_config,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  ///
  /// Updates a notification config. The following update
  /// fields are allowed: description, pubsub_topic, streaming_config.filter
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::UpdateNotificationConfigRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1638}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::NotificationConfig,google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  /// [google.cloud.securitycenter.v1.UpdateNotificationConfigRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1638}
  /// [google.cloud.securitycenter.v1.NotificationConfig]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/notification_config.proto#L39}
  ///
  StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
  UpdateNotificationConfig(
      google::cloud::securitycenter::v1::UpdateNotificationConfigRequest const&
          request,
      Options options = {});

  ///
  /// Updates an organization's settings.
  ///
  /// @param organization_settings  Required. The organization settings resource
  /// to update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::OrganizationSettings,google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  /// [google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1649}
  /// [google.cloud.securitycenter.v1.OrganizationSettings]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
  UpdateOrganizationSettings(
      google::cloud::securitycenter::v1::OrganizationSettings const&
          organization_settings,
      Options options = {});

  ///
  /// Updates an organization's settings.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::UpdateOrganizationSettingsRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1649}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::OrganizationSettings,google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  /// [google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1649}
  /// [google.cloud.securitycenter.v1.OrganizationSettings]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/organization_settings.proto#L31}
  ///
  StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
  UpdateOrganizationSettings(
      google::cloud::securitycenter::v1::
          UpdateOrganizationSettingsRequest const& request,
      Options options = {});

  ///
  /// Updates a source.
  ///
  /// @param source  Required. The source resource to update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.UpdateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1660}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::Source> UpdateSource(
      google::cloud::securitycenter::v1::Source const& source,
      Options options = {});

  ///
  /// Updates a source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::UpdateSourceRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1660}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::Source,google/cloud/securitycenter/v1/source.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.UpdateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1660}
  /// [google.cloud.securitycenter.v1.Source]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/source.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::Source> UpdateSource(
      google::cloud::securitycenter::v1::UpdateSourceRequest const& request,
      Options options = {});

  ///
  /// Updates security marks.
  ///
  /// @param security_marks  Required. The security marks resource to update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::SecurityMarks,google/cloud/securitycenter/v1/security_marks.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.UpdateSecurityMarksRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1671}
  /// [google.cloud.securitycenter.v1.SecurityMarks]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/security_marks.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::SecurityMarks>
  UpdateSecurityMarks(
      google::cloud::securitycenter::v1::SecurityMarks const& security_marks,
      Options options = {});

  ///
  /// Updates security marks.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::securitycenter::v1::UpdateSecurityMarksRequest,google/cloud/securitycenter/v1/securitycenter_service.proto#L1671}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::securitycenter::v1::SecurityMarks,google/cloud/securitycenter/v1/security_marks.proto#L33}
  ///
  /// [google.cloud.securitycenter.v1.UpdateSecurityMarksRequest]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/securitycenter_service.proto#L1671}
  /// [google.cloud.securitycenter.v1.SecurityMarks]:
  /// @googleapis_reference_link{google/cloud/securitycenter/v1/security_marks.proto#L33}
  ///
  StatusOr<google::cloud::securitycenter::v1::SecurityMarks>
  UpdateSecurityMarks(
      google::cloud::securitycenter::v1::UpdateSecurityMarksRequest const&
          request,
      Options options = {});

 private:
  std::shared_ptr<SecurityCenterConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycenter
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTER_SECURITY_CENTER_CLIENT_H
