// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

#include "google/cloud/securitycenter/internal/security_center_connection_impl.h"
#include "google/cloud/securitycenter/internal/security_center_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace securitycenter_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecurityCenterConnectionImpl::SecurityCenterConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<securitycenter_internal::SecurityCenterStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          securitycenter_internal::SecurityCenterDefaultOptions(
              SecurityCenterConnection::options()))) {}

future<StatusOr<google::cloud::securitycenter::v1::BulkMuteFindingsResponse>>
SecurityCenterConnectionImpl::BulkMuteFindings(
    google::cloud::securitycenter::v1::BulkMuteFindingsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::securitycenter::v1::BulkMuteFindingsResponse>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::securitycenter::v1::BulkMuteFindingsRequest const&
                 request) {
        return stub->AsyncBulkMuteFindings(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::securitycenter::v1::BulkMuteFindingsResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->BulkMuteFindings(request), polling_policy(),
      __func__);
}

StatusOr<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::CreateSource(
    google::cloud::securitycenter::v1::CreateSourceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateSource(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::CreateSourceRequest const&
                 request) { return stub_->CreateSource(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::CreateFinding(
    google::cloud::securitycenter::v1::CreateFindingRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateFinding(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::CreateFindingRequest const&
                 request) { return stub_->CreateFinding(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::CreateMuteConfig(
    google::cloud::securitycenter::v1::CreateMuteConfigRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::CreateMuteConfigRequest const&
                 request) { return stub_->CreateMuteConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::CreateNotificationConfig(
    google::cloud::securitycenter::v1::CreateNotificationConfigRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateNotificationConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 CreateNotificationConfigRequest const& request) {
        return stub_->CreateNotificationConfig(context, request);
      },
      request, __func__);
}

Status SecurityCenterConnectionImpl::DeleteMuteConfig(
    google::cloud::securitycenter::v1::DeleteMuteConfigRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::DeleteMuteConfigRequest const&
                 request) { return stub_->DeleteMuteConfig(context, request); },
      request, __func__);
}

Status SecurityCenterConnectionImpl::DeleteNotificationConfig(
    google::cloud::securitycenter::v1::DeleteNotificationConfigRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteNotificationConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 DeleteNotificationConfigRequest const& request) {
        return stub_->DeleteNotificationConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> SecurityCenterConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::GetMuteConfig(
    google::cloud::securitycenter::v1::GetMuteConfigRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::GetMuteConfigRequest const&
                 request) { return stub_->GetMuteConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::GetNotificationConfig(
    google::cloud::securitycenter::v1::GetNotificationConfigRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetNotificationConfig(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::GetNotificationConfigRequest const&
              request) {
        return stub_->GetNotificationConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
SecurityCenterConnectionImpl::GetOrganizationSettings(
    google::cloud::securitycenter::v1::GetOrganizationSettingsRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetOrganizationSettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 GetOrganizationSettingsRequest const& request) {
        return stub_->GetOrganizationSettings(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::GetSource(
    google::cloud::securitycenter::v1::GetSourceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetSource(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::GetSourceRequest const& request) {
        return stub_->GetSource(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::securitycenter::v1::GroupResult>
SecurityCenterConnectionImpl::GroupAssets(
    google::cloud::securitycenter::v1::GroupAssetsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<securitycenter::SecurityCenterRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->GroupAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::GroupResult>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::securitycenter::v1::GroupAssetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::GroupAssetsRequest const&
                       request) { return stub->GroupAssets(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::GroupAssetsResponse r) {
        std::vector<google::cloud::securitycenter::v1::GroupResult> result(
            r.group_by_results().size());
        auto& messages = *r.mutable_group_by_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::GroupResult>
SecurityCenterConnectionImpl::GroupFindings(
    google::cloud::securitycenter::v1::GroupFindingsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<securitycenter::SecurityCenterRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->GroupFindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::GroupResult>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::securitycenter::v1::GroupFindingsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::securitycenter::v1::GroupFindingsRequest const&
                    request) { return stub->GroupFindings(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::GroupFindingsResponse r) {
        std::vector<google::cloud::securitycenter::v1::GroupResult> result(
            r.group_by_results().size());
        auto& messages = *r.mutable_group_by_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<
    google::cloud::securitycenter::v1::ListAssetsResponse::ListAssetsResult>
SecurityCenterConnectionImpl::ListAssets(
    google::cloud::securitycenter::v1::ListAssetsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<securitycenter::SecurityCenterRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::securitycenter::v1::ListAssetsResponse::ListAssetsResult>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::securitycenter::v1::ListAssetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::ListAssetsRequest const&
                       request) { return stub->ListAssets(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListAssetsResponse r) {
        std::vector<google::cloud::securitycenter::v1::ListAssetsResponse::
                        ListAssetsResult>
            result(r.list_assets_results().size());
        auto& messages = *r.mutable_list_assets_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<
    google::cloud::securitycenter::v1::ListFindingsResponse::ListFindingsResult>
SecurityCenterConnectionImpl::ListFindings(
    google::cloud::securitycenter::v1::ListFindingsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<securitycenter::SecurityCenterRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListFindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::ListFindingsResponse::
                      ListFindingsResult>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::securitycenter::v1::ListFindingsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::ListFindingsRequest const&
                       request) {
              return stub->ListFindings(context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListFindingsResponse r) {
        std::vector<google::cloud::securitycenter::v1::ListFindingsResponse::
                        ListFindingsResult>
            result(r.list_findings_results().size());
        auto& messages = *r.mutable_list_findings_results();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::ListMuteConfigs(
    google::cloud::securitycenter::v1::ListMuteConfigsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<securitycenter::SecurityCenterRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListMuteConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::MuteConfig>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::securitycenter::v1::ListMuteConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::securitycenter::v1::ListMuteConfigsRequest const&
                    request) {
              return stub->ListMuteConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListMuteConfigsResponse r) {
        std::vector<google::cloud::securitycenter::v1::MuteConfig> result(
            r.mute_configs().size());
        auto& messages = *r.mutable_mute_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::ListNotificationConfigs(
    google::cloud::securitycenter::v1::ListNotificationConfigsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<securitycenter::SecurityCenterRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListNotificationConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::NotificationConfig>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::securitycenter::v1::
                          ListNotificationConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::
                       ListNotificationConfigsRequest const& request) {
              return stub->ListNotificationConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListNotificationConfigsResponse r) {
        std::vector<google::cloud::securitycenter::v1::NotificationConfig>
            result(r.notification_configs().size());
        auto& messages = *r.mutable_notification_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::ListSources(
    google::cloud::securitycenter::v1::ListSourcesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<securitycenter::SecurityCenterRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListSources(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::securitycenter::v1::Source>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::securitycenter::v1::ListSourcesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::securitycenter::v1::ListSourcesRequest const&
                       request) { return stub->ListSources(context, request); },
            r, function_name);
      },
      [](google::cloud::securitycenter::v1::ListSourcesResponse r) {
        std::vector<google::cloud::securitycenter::v1::Source> result(
            r.sources().size());
        auto& messages = *r.mutable_sources();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>>
SecurityCenterConnectionImpl::RunAssetDiscovery(
    google::cloud::securitycenter::v1::RunAssetDiscoveryRequest const&
        request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::securitycenter::v1::RunAssetDiscoveryRequest const&
                 request) {
        return stub->AsyncRunAssetDiscovery(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::securitycenter::v1::RunAssetDiscoveryResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->RunAssetDiscovery(request), polling_policy(),
      __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::SetFindingState(
    google::cloud::securitycenter::v1::SetFindingStateRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetFindingState(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::SetFindingStateRequest const&
                 request) { return stub_->SetFindingState(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::SetMute(
    google::cloud::securitycenter::v1::SetMuteRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(), idempotency_policy()->SetMute(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::SetMuteRequest const& request) {
        return stub_->SetMute(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> SecurityCenterConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecurityCenterConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::ExternalSystem>
SecurityCenterConnectionImpl::UpdateExternalSystem(
    google::cloud::securitycenter::v1::UpdateExternalSystemRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateExternalSystem(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::UpdateExternalSystemRequest const&
              request) {
        return stub_->UpdateExternalSystem(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Finding>
SecurityCenterConnectionImpl::UpdateFinding(
    google::cloud::securitycenter::v1::UpdateFindingRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateFinding(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::UpdateFindingRequest const&
                 request) { return stub_->UpdateFinding(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::MuteConfig>
SecurityCenterConnectionImpl::UpdateMuteConfig(
    google::cloud::securitycenter::v1::UpdateMuteConfigRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateMuteConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::UpdateMuteConfigRequest const&
                 request) { return stub_->UpdateMuteConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::NotificationConfig>
SecurityCenterConnectionImpl::UpdateNotificationConfig(
    google::cloud::securitycenter::v1::UpdateNotificationConfigRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateNotificationConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 UpdateNotificationConfigRequest const& request) {
        return stub_->UpdateNotificationConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::OrganizationSettings>
SecurityCenterConnectionImpl::UpdateOrganizationSettings(
    google::cloud::securitycenter::v1::UpdateOrganizationSettingsRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateOrganizationSettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::
                 UpdateOrganizationSettingsRequest const& request) {
        return stub_->UpdateOrganizationSettings(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::Source>
SecurityCenterConnectionImpl::UpdateSource(
    google::cloud::securitycenter::v1::UpdateSourceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateSource(request),
      [this](grpc::ClientContext& context,
             google::cloud::securitycenter::v1::UpdateSourceRequest const&
                 request) { return stub_->UpdateSource(context, request); },
      request, __func__);
}

StatusOr<google::cloud::securitycenter::v1::SecurityMarks>
SecurityCenterConnectionImpl::UpdateSecurityMarks(
    google::cloud::securitycenter::v1::UpdateSecurityMarksRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateSecurityMarks(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::securitycenter::v1::UpdateSecurityMarksRequest const&
              request) { return stub_->UpdateSecurityMarks(context, request); },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycenter_internal
}  // namespace cloud
}  // namespace google
