// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#include "google/cloud/secretmanager/secret_manager_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace secretmanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SecretManagerServiceConnectionIdempotencyPolicy::
    ~SecretManagerServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultSecretManagerServiceConnectionIdempotencyPolicy
    : public SecretManagerServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultSecretManagerServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<SecretManagerServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultSecretManagerServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListSecrets(
      google::cloud::secretmanager::v1::ListSecretsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateSecret(
      google::cloud::secretmanager::v1::CreateSecretRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency AddSecretVersion(
      google::cloud::secretmanager::v1::AddSecretVersionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetSecret(
      google::cloud::secretmanager::v1::GetSecretRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateSecret(
      google::cloud::secretmanager::v1::UpdateSecretRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteSecret(
      google::cloud::secretmanager::v1::DeleteSecretRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListSecretVersions(
      google::cloud::secretmanager::v1::ListSecretVersionsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetSecretVersion(
      google::cloud::secretmanager::v1::GetSecretVersionRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency AccessSecretVersion(
      google::cloud::secretmanager::v1::AccessSecretVersionRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency DisableSecretVersion(
      google::cloud::secretmanager::v1::DisableSecretVersionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency EnableSecretVersion(
      google::cloud::secretmanager::v1::EnableSecretVersionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DestroySecretVersion(
      google::cloud::secretmanager::v1::DestroySecretVersionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<SecretManagerServiceConnectionIdempotencyPolicy>
MakeDefaultSecretManagerServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultSecretManagerServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager
}  // namespace cloud
}  // namespace google
