// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#include "google/cloud/secretmanager/internal/secret_manager_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/secretmanager/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace secretmanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecretManagerServiceStub::~SecretManagerServiceStub() = default;

StatusOr<google::cloud::secretmanager::v1::ListSecretsResponse>
DefaultSecretManagerServiceStub::ListSecrets(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::ListSecretsRequest const& request) {
  google::cloud::secretmanager::v1::ListSecretsResponse response;
  auto status = grpc_stub_->ListSecrets(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::Secret>
DefaultSecretManagerServiceStub::CreateSecret(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::CreateSecretRequest const& request) {
  google::cloud::secretmanager::v1::Secret response;
  auto status = grpc_stub_->CreateSecret(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
DefaultSecretManagerServiceStub::AddSecretVersion(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::AddSecretVersionRequest const& request) {
  google::cloud::secretmanager::v1::SecretVersion response;
  auto status =
      grpc_stub_->AddSecretVersion(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::Secret>
DefaultSecretManagerServiceStub::GetSecret(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::GetSecretRequest const& request) {
  google::cloud::secretmanager::v1::Secret response;
  auto status = grpc_stub_->GetSecret(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::Secret>
DefaultSecretManagerServiceStub::UpdateSecret(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::UpdateSecretRequest const& request) {
  google::cloud::secretmanager::v1::Secret response;
  auto status = grpc_stub_->UpdateSecret(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultSecretManagerServiceStub::DeleteSecret(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::DeleteSecretRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteSecret(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::secretmanager::v1::ListSecretVersionsResponse>
DefaultSecretManagerServiceStub::ListSecretVersions(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::ListSecretVersionsRequest const&
        request) {
  google::cloud::secretmanager::v1::ListSecretVersionsResponse response;
  auto status =
      grpc_stub_->ListSecretVersions(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
DefaultSecretManagerServiceStub::GetSecretVersion(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::GetSecretVersionRequest const& request) {
  google::cloud::secretmanager::v1::SecretVersion response;
  auto status =
      grpc_stub_->GetSecretVersion(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::AccessSecretVersionResponse>
DefaultSecretManagerServiceStub::AccessSecretVersion(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
        request) {
  google::cloud::secretmanager::v1::AccessSecretVersionResponse response;
  auto status =
      grpc_stub_->AccessSecretVersion(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
DefaultSecretManagerServiceStub::DisableSecretVersion(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
        request) {
  google::cloud::secretmanager::v1::SecretVersion response;
  auto status =
      grpc_stub_->DisableSecretVersion(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
DefaultSecretManagerServiceStub::EnableSecretVersion(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
        request) {
  google::cloud::secretmanager::v1::SecretVersion response;
  auto status =
      grpc_stub_->EnableSecretVersion(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
DefaultSecretManagerServiceStub::DestroySecretVersion(
    grpc::ClientContext& client_context,
    google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
        request) {
  google::cloud::secretmanager::v1::SecretVersion response;
  auto status =
      grpc_stub_->DestroySecretVersion(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultSecretManagerServiceStub::SetIamPolicy(
    grpc::ClientContext& client_context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->SetIamPolicy(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultSecretManagerServiceStub::GetIamPolicy(
    grpc::ClientContext& client_context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->GetIamPolicy(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DefaultSecretManagerServiceStub::TestIamPermissions(
    grpc::ClientContext& client_context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  google::iam::v1::TestIamPermissionsResponse response;
  auto status =
      grpc_stub_->TestIamPermissions(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager_internal
}  // namespace cloud
}  // namespace google
