// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#include "google/cloud/secretmanager/internal/secret_manager_connection_impl.h"
#include "google/cloud/secretmanager/internal/secret_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace secretmanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SecretManagerServiceConnectionImpl::SecretManagerServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<secretmanager_internal::SecretManagerServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          secretmanager_internal::SecretManagerServiceDefaultOptions(
              SecretManagerServiceConnection::options()))) {}

StreamRange<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceConnectionImpl::ListSecrets(
    google::cloud::secretmanager::v1::ListSecretsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<secretmanager::SecretManagerServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListSecrets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::secretmanager::v1::Secret>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::secretmanager::v1::ListSecretsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::secretmanager::v1::ListSecretsRequest const&
                       request) { return stub->ListSecrets(context, request); },
            r, function_name);
      },
      [](google::cloud::secretmanager::v1::ListSecretsResponse r) {
        std::vector<google::cloud::secretmanager::v1::Secret> result(
            r.secrets().size());
        auto& messages = *r.mutable_secrets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceConnectionImpl::CreateSecret(
    google::cloud::secretmanager::v1::CreateSecretRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateSecret(request),
      [this](grpc::ClientContext& context,
             google::cloud::secretmanager::v1::CreateSecretRequest const&
                 request) { return stub_->CreateSecret(context, request); },
      request, __func__);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceConnectionImpl::AddSecretVersion(
    google::cloud::secretmanager::v1::AddSecretVersionRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->AddSecretVersion(request),
      [this](grpc::ClientContext& context,
             google::cloud::secretmanager::v1::AddSecretVersionRequest const&
                 request) { return stub_->AddSecretVersion(context, request); },
      request, __func__);
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceConnectionImpl::GetSecret(
    google::cloud::secretmanager::v1::GetSecretRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetSecret(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::secretmanager::v1::GetSecretRequest const& request) {
        return stub_->GetSecret(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::secretmanager::v1::Secret>
SecretManagerServiceConnectionImpl::UpdateSecret(
    google::cloud::secretmanager::v1::UpdateSecretRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateSecret(request),
      [this](grpc::ClientContext& context,
             google::cloud::secretmanager::v1::UpdateSecretRequest const&
                 request) { return stub_->UpdateSecret(context, request); },
      request, __func__);
}

Status SecretManagerServiceConnectionImpl::DeleteSecret(
    google::cloud::secretmanager::v1::DeleteSecretRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteSecret(request),
      [this](grpc::ClientContext& context,
             google::cloud::secretmanager::v1::DeleteSecretRequest const&
                 request) { return stub_->DeleteSecret(context, request); },
      request, __func__);
}

StreamRange<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceConnectionImpl::ListSecretVersions(
    google::cloud::secretmanager::v1::ListSecretVersionsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<secretmanager::SecretManagerServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListSecretVersions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::secretmanager::v1::SecretVersion>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::secretmanager::v1::ListSecretVersionsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::secretmanager::v1::
                       ListSecretVersionsRequest const& request) {
              return stub->ListSecretVersions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::secretmanager::v1::ListSecretVersionsResponse r) {
        std::vector<google::cloud::secretmanager::v1::SecretVersion> result(
            r.versions().size());
        auto& messages = *r.mutable_versions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceConnectionImpl::GetSecretVersion(
    google::cloud::secretmanager::v1::GetSecretVersionRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetSecretVersion(request),
      [this](grpc::ClientContext& context,
             google::cloud::secretmanager::v1::GetSecretVersionRequest const&
                 request) { return stub_->GetSecretVersion(context, request); },
      request, __func__);
}

StatusOr<google::cloud::secretmanager::v1::AccessSecretVersionResponse>
SecretManagerServiceConnectionImpl::AccessSecretVersion(
    google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->AccessSecretVersion(request),
      [this](grpc::ClientContext& context,
             google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
                 request) {
        return stub_->AccessSecretVersion(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceConnectionImpl::DisableSecretVersion(
    google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DisableSecretVersion(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
              request) {
        return stub_->DisableSecretVersion(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceConnectionImpl::EnableSecretVersion(
    google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->EnableSecretVersion(request),
      [this](grpc::ClientContext& context,
             google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
                 request) {
        return stub_->EnableSecretVersion(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::secretmanager::v1::SecretVersion>
SecretManagerServiceConnectionImpl::DestroySecretVersion(
    google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DestroySecretVersion(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
              request) {
        return stub_->DestroySecretVersion(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy>
SecretManagerServiceConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy>
SecretManagerServiceConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SecretManagerServiceConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager_internal
}  // namespace cloud
}  // namespace google
