// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/scheduler/v1/cloudscheduler.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SCHEDULER_CLOUD_SCHEDULER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SCHEDULER_CLOUD_SCHEDULER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/cloud/scheduler/v1/cloudscheduler.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace scheduler {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudSchedulerConnectionIdempotencyPolicy {
 public:
  virtual ~CloudSchedulerConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<CloudSchedulerConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency ListJobs(
      google::cloud::scheduler::v1::ListJobsRequest request) = 0;

  virtual google::cloud::Idempotency GetJob(
      google::cloud::scheduler::v1::GetJobRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateJob(
      google::cloud::scheduler::v1::CreateJobRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateJob(
      google::cloud::scheduler::v1::UpdateJobRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteJob(
      google::cloud::scheduler::v1::DeleteJobRequest const& request) = 0;

  virtual google::cloud::Idempotency PauseJob(
      google::cloud::scheduler::v1::PauseJobRequest const& request) = 0;

  virtual google::cloud::Idempotency ResumeJob(
      google::cloud::scheduler::v1::ResumeJobRequest const& request) = 0;

  virtual google::cloud::Idempotency RunJob(
      google::cloud::scheduler::v1::RunJobRequest const& request) = 0;
};

std::unique_ptr<CloudSchedulerConnectionIdempotencyPolicy>
MakeDefaultCloudSchedulerConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace scheduler
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SCHEDULER_CLOUD_SCHEDULER_CONNECTION_IDEMPOTENCY_POLICY_H
