// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/user_event_service.proto

#include "google/cloud/retail/user_event_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

UserEventServiceConnectionIdempotencyPolicy::
    ~UserEventServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultUserEventServiceConnectionIdempotencyPolicy
    : public UserEventServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultUserEventServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<UserEventServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultUserEventServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency WriteUserEvent(
      google::cloud::retail::v2::WriteUserEventRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CollectUserEvent(
      google::cloud::retail::v2::CollectUserEventRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency PurgeUserEvents(
      google::cloud::retail::v2::PurgeUserEventsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ImportUserEvents(
      google::cloud::retail::v2::ImportUserEventsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RejoinUserEvents(
      google::cloud::retail::v2::RejoinUserEventsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<UserEventServiceConnectionIdempotencyPolicy>
MakeDefaultUserEventServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultUserEventServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail
}  // namespace cloud
}  // namespace google
