// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/user_event_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_USER_EVENT_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_USER_EVENT_CLIENT_H

#include "google/cloud/retail/user_event_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace retail {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for ingesting end user actions on the customer website.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class UserEventServiceClient {
 public:
  explicit UserEventServiceClient(
      std::shared_ptr<UserEventServiceConnection> connection,
      Options options = {});
  ~UserEventServiceClient();

  //@{
  // @name Copy and move support
  UserEventServiceClient(UserEventServiceClient const&) = default;
  UserEventServiceClient& operator=(UserEventServiceClient const&) = default;
  UserEventServiceClient(UserEventServiceClient&&) = default;
  UserEventServiceClient& operator=(UserEventServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(UserEventServiceClient const& a,
                         UserEventServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(UserEventServiceClient const& a,
                         UserEventServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Writes a single user event.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::WriteUserEventRequest,google/cloud/retail/v2/user_event_service.proto#L118}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::UserEvent,google/cloud/retail/v2/user_event.proto#L37}
  ///
  /// [google.cloud.retail.v2.WriteUserEventRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/user_event_service.proto#L118}
  /// [google.cloud.retail.v2.UserEvent]:
  /// @googleapis_reference_link{google/cloud/retail/v2/user_event.proto#L37}
  ///
  StatusOr<google::cloud::retail::v2::UserEvent> WriteUserEvent(
      google::cloud::retail::v2::WriteUserEventRequest const& request,
      Options options = {});

  ///
  /// Writes a single user event from the browser. This uses a GET request to
  /// due to browser restriction of POST-ing to a 3rd party domain.
  ///
  /// This method is used only by the Retail API JavaScript pixel and Google Tag
  /// Manager. Users should not call this method directly.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::CollectUserEventRequest,google/cloud/retail/v2/user_event_service.proto#L128}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::api::HttpBody,google/api/httpbody.proto#L71}
  ///
  /// [google.cloud.retail.v2.CollectUserEventRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/user_event_service.proto#L128}
  /// [google.api.HttpBody]:
  /// @googleapis_reference_link{google/api/httpbody.proto#L71}
  ///
  StatusOr<google::api::HttpBody> CollectUserEvent(
      google::cloud::retail::v2::CollectUserEventRequest const& request,
      Options options = {});

  ///
  /// Deletes permanently all user events specified by the filter provided.
  /// Depending on the number of events specified by the filter, this operation
  /// could take hours or days to complete. To test a filter, use the list
  /// command first.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::PurgeUserEventsRequest,google/cloud/retail/v2/purge_config.proto#L36}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::PurgeUserEventsResponse,google/cloud/retail/v2/purge_config.proto#L76}
  ///
  /// [google.cloud.retail.v2.PurgeUserEventsRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/purge_config.proto#L36}
  /// [google.cloud.retail.v2.PurgeUserEventsResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/purge_config.proto#L76}
  ///
  future<StatusOr<google::cloud::retail::v2::PurgeUserEventsResponse>>
  PurgeUserEvents(
      google::cloud::retail::v2::PurgeUserEventsRequest const& request,
      Options options = {});

  ///
  /// Bulk import of User events. Request processing might be
  /// synchronous. Events that already exist are skipped.
  /// Use this method for backfilling historical user events.
  ///
  /// Operation.response is of type ImportResponse. Note that it is
  /// possible for a subset of the items to be successfully inserted.
  /// Operation.metadata is of type ImportMetadata.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::ImportUserEventsRequest,google/cloud/retail/v2/import_config.proto#L222}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::ImportUserEventsResponse,google/cloud/retail/v2/import_config.proto#L357}
  ///
  /// [google.cloud.retail.v2.ImportUserEventsRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/import_config.proto#L222}
  /// [google.cloud.retail.v2.ImportUserEventsResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/import_config.proto#L357}
  ///
  future<StatusOr<google::cloud::retail::v2::ImportUserEventsResponse>>
  ImportUserEvents(
      google::cloud::retail::v2::ImportUserEventsRequest const& request,
      Options options = {});

  ///
  /// Triggers a user event rejoin operation with latest product catalog. Events
  /// will not be annotated with detailed product information if product is
  /// missing from the catalog at the time the user event is ingested, and these
  /// events are stored as unjoined events with a limited usage on training and
  /// serving. This API can be used to trigger a 'join' operation on specified
  /// events with latest version of product catalog. It can also be used to
  /// correct events joined with wrong product catalog.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::RejoinUserEventsRequest,google/cloud/retail/v2/user_event_service.proto#L150}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::RejoinUserEventsResponse,google/cloud/retail/v2/user_event_service.proto#L182}
  ///
  /// [google.cloud.retail.v2.RejoinUserEventsRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/user_event_service.proto#L150}
  /// [google.cloud.retail.v2.RejoinUserEventsResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/user_event_service.proto#L182}
  ///
  future<StatusOr<google::cloud::retail::v2::RejoinUserEventsResponse>>
  RejoinUserEvents(
      google::cloud::retail::v2::RejoinUserEventsRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<UserEventServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_USER_EVENT_CLIENT_H
