// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/product_service.proto

#include "google/cloud/retail/product_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ProductServiceConnectionIdempotencyPolicy::
    ~ProductServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultProductServiceConnectionIdempotencyPolicy
    : public ProductServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultProductServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ProductServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultProductServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency CreateProduct(
      google::cloud::retail::v2::CreateProductRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetProduct(
      google::cloud::retail::v2::GetProductRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListProducts(
      google::cloud::retail::v2::ListProductsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateProduct(
      google::cloud::retail::v2::UpdateProductRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteProduct(
      google::cloud::retail::v2::DeleteProductRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ImportProducts(
      google::cloud::retail::v2::ImportProductsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetInventory(
      google::cloud::retail::v2::SetInventoryRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency AddFulfillmentPlaces(
      google::cloud::retail::v2::AddFulfillmentPlacesRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RemoveFulfillmentPlaces(
      google::cloud::retail::v2::RemoveFulfillmentPlacesRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ProductServiceConnectionIdempotencyPolicy>
MakeDefaultProductServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultProductServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail
}  // namespace cloud
}  // namespace google
