// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/product_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_PRODUCT_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_PRODUCT_CLIENT_H

#include "google/cloud/retail/product_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace retail {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for ingesting [Product][google.cloud.retail.v2.Product] information
/// of the customer's website.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ProductServiceClient {
 public:
  explicit ProductServiceClient(
      std::shared_ptr<ProductServiceConnection> connection,
      Options options = {});
  ~ProductServiceClient();

  //@{
  // @name Copy and move support
  ProductServiceClient(ProductServiceClient const&) = default;
  ProductServiceClient& operator=(ProductServiceClient const&) = default;
  ProductServiceClient(ProductServiceClient&&) = default;
  ProductServiceClient& operator=(ProductServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ProductServiceClient const& a,
                         ProductServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ProductServiceClient const& a,
                         ProductServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param parent  Required. The parent catalog resource name, such as
  ///  `projects/*/locations/global/catalogs/default_catalog/branches/default_branch`.
  /// @param product  Required. The [Product][google.cloud.retail.v2.Product] to
  /// create.
  /// @param product_id  Required. The ID to use for the
  /// [Product][google.cloud.retail.v2.Product],
  ///  which will become the final component of the
  ///  [Product.name][google.cloud.retail.v2.Product.name].
  ///  If the caller does not have permission to create the
  ///  [Product][google.cloud.retail.v2.Product], regardless of whether or not
  ///  it exists, a PERMISSION_DENIED error is returned. This field must be
  ///  unique among all [Product][google.cloud.retail.v2.Product]s with the same
  ///  [parent][google.cloud.retail.v2.CreateProductRequest.parent]. Otherwise,
  ///  an ALREADY_EXISTS error is returned. This field must be a UTF-8 encoded
  ///  string with a length limit of 128 characters. Otherwise, an
  ///  INVALID_ARGUMENT error is returned.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.CreateProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L219}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StatusOr<google::cloud::retail::v2::Product> CreateProduct(
      std::string const& parent,
      google::cloud::retail::v2::Product const& product,
      std::string const& product_id, Options options = {});

  ///
  /// Creates a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::CreateProductRequest,google/cloud/retail/v2/product_service.proto#L219}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.CreateProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L219}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StatusOr<google::cloud::retail::v2::Product> CreateProduct(
      google::cloud::retail::v2::CreateProductRequest const& request,
      Options options = {});

  ///
  /// Gets a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param name  Required. Full resource name of
  /// [Product][google.cloud.retail.v2.Product],
  ///  such as
  ///  `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
  ///  If the caller does not have permission to access the
  ///  [Product][google.cloud.retail.v2.Product], regardless of whether or not
  ///  it exists, a PERMISSION_DENIED error is returned. If the requested
  ///  [Product][google.cloud.retail.v2.Product] does not exist, a NOT_FOUND
  ///  error is returned.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.GetProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L249}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StatusOr<google::cloud::retail::v2::Product> GetProduct(
      std::string const& name, Options options = {});

  ///
  /// Gets a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::GetProductRequest,google/cloud/retail/v2/product_service.proto#L249}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.GetProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L249}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StatusOr<google::cloud::retail::v2::Product> GetProduct(
      google::cloud::retail::v2::GetProductRequest const& request,
      Options options = {});

  ///
  /// Gets a list of [Product][google.cloud.retail.v2.Product]s.
  ///
  /// @param parent  Required. The parent branch resource name, such as
  ///  `projects/*/locations/global/catalogs/default_catalog/branches/0`. Use
  ///  `default_branch` as the branch ID, to list products under the default
  ///  branch.
  ///  If the caller does not have permission to list
  ///  [Product][google.cloud.retail.v2.Product]s under this branch, regardless
  ///  of whether or not this branch exists, a PERMISSION_DENIED error is
  ///  returned.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.ListProductsRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L327}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StreamRange<google::cloud::retail::v2::Product> ListProducts(
      std::string const& parent, Options options = {});

  ///
  /// Gets a list of [Product][google.cloud.retail.v2.Product]s.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::ListProductsRequest,google/cloud/retail/v2/product_service.proto#L327}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.ListProductsRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L327}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StreamRange<google::cloud::retail::v2::Product> ListProducts(
      google::cloud::retail::v2::ListProductsRequest request,
      Options options = {});

  ///
  /// Updates a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param product  Required. The product to update/create.
  ///  If the caller does not have permission to update the
  ///  [Product][google.cloud.retail.v2.Product], regardless of whether or not
  ///  it exists, a PERMISSION_DENIED error is returned. If the
  ///  [Product][google.cloud.retail.v2.Product] to update does not exist and
  ///  [allow_missing][google.cloud.retail.v2.UpdateProductRequest.allow_missing]
  ///  is not set, a NOT_FOUND error is returned.
  /// @param update_mask  Indicates which fields in the provided
  ///  [Product][google.cloud.retail.v2.Product] to update. The immutable and
  ///  output only fields are NOT supported. If not set, all supported fields
  ///  (the fields that are neither immutable nor output only) are updated. If
  ///  an unsupported or unknown field is provided, an INVALID_ARGUMENT error is
  ///  returned.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.UpdateProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L267}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StatusOr<google::cloud::retail::v2::Product> UpdateProduct(
      google::cloud::retail::v2::Product const& product,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::UpdateProductRequest,google/cloud/retail/v2/product_service.proto#L267}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::Product,google/cloud/retail/v2/product.proto#L43}
  ///
  /// [google.cloud.retail.v2.UpdateProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L267}
  /// [google.cloud.retail.v2.Product]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product.proto#L43}
  ///
  StatusOr<google::cloud::retail::v2::Product> UpdateProduct(
      google::cloud::retail::v2::UpdateProductRequest const& request,
      Options options = {});

  ///
  /// Deletes a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param name  Required. Full resource name of
  /// [Product][google.cloud.retail.v2.Product],
  ///  such as
  ///  `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
  ///  If the caller does not have permission to delete the
  ///  [Product][google.cloud.retail.v2.Product], regardless of whether or not
  ///  it exists, a PERMISSION_DENIED error is returned. If the
  ///  [Product][google.cloud.retail.v2.Product] to delete does not exist, a
  ///  NOT_FOUND error is returned. The
  ///  [Product][google.cloud.retail.v2.Product] to delete can neither be a
  ///  [Product.Type.COLLECTION][google.cloud.retail.v2.Product.Type.COLLECTION]
  ///  [Product][google.cloud.retail.v2.Product] member nor a
  ///  [Product.Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
  ///  [Product][google.cloud.retail.v2.Product] with more than one
  ///  [variants][google.cloud.retail.v2.Product.Type.VARIANT]. Otherwise, an
  ///  INVALID_ARGUMENT error is returned.
  ///  All inventory information for the named
  ///  [Product][google.cloud.retail.v2.Product] will be deleted.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.retail.v2.DeleteProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L296}
  ///
  Status DeleteProduct(std::string const& name, Options options = {});

  ///
  /// Deletes a [Product][google.cloud.retail.v2.Product].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::DeleteProductRequest,google/cloud/retail/v2/product_service.proto#L296}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.retail.v2.DeleteProductRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L296}
  ///
  Status DeleteProduct(
      google::cloud::retail::v2::DeleteProductRequest const& request,
      Options options = {});

  ///
  /// Bulk import of multiple [Product][google.cloud.retail.v2.Product]s.
  ///
  /// Request processing may be synchronous. No partial updating is supported.
  /// Non-existing items are created.
  ///
  /// Note that it is possible for a subset of the
  /// [Product][google.cloud.retail.v2.Product]s to be successfully updated.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::ImportProductsRequest,google/cloud/retail/v2/import_config.proto#L147}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::ImportProductsResponse,google/cloud/retail/v2/import_config.proto#L346}
  ///
  /// [google.cloud.retail.v2.ImportProductsRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/import_config.proto#L147}
  /// [google.cloud.retail.v2.ImportProductsResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/import_config.proto#L346}
  ///
  future<StatusOr<google::cloud::retail::v2::ImportProductsResponse>>
  ImportProducts(
      google::cloud::retail::v2::ImportProductsRequest const& request,
      Options options = {});

  ///
  /// Updates inventory information for a
  /// [Product][google.cloud.retail.v2.Product] while respecting the last update
  /// timestamps of each inventory field.
  ///
  /// This process is asynchronous and does not require the
  /// [Product][google.cloud.retail.v2.Product] to exist before updating
  /// fulfillment information. If the request is valid, the update will be
  /// enqueued and processed downstream. As a consequence, when a response is
  /// returned, updates are not immediately manifested in the
  /// [Product][google.cloud.retail.v2.Product] queried by
  /// [GetProduct][google.cloud.retail.v2.ProductService.GetProduct] or
  /// [ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
  ///
  /// When inventory is updated with
  /// [CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct] and
  /// [UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct], the
  /// specified inventory field value(s) will overwrite any existing value(s)
  /// while ignoring the last update time for this field. Furthermore, the last
  /// update time for the specified inventory fields will be overwritten to the
  /// time of the
  /// [CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct] or
  /// [UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct]
  /// request.
  ///
  /// If no inventory fields are set in
  /// [CreateProductRequest.product][google.cloud.retail.v2.CreateProductRequest.product],
  /// then any pre-existing inventory information for this product will be used.
  ///
  /// If no inventory fields are set in [UpdateProductRequest.set_mask][],
  /// then any existing inventory information will be preserved.
  ///
  /// Pre-existing inventory information can only be updated with
  /// [SetInventory][google.cloud.retail.v2.ProductService.SetInventory],
  /// [AddFulfillmentPlaces][google.cloud.retail.v2.ProductService.AddFulfillmentPlaces],
  /// and
  /// [RemoveFulfillmentPlaces][google.cloud.retail.v2.ProductService.RemoveFulfillmentPlaces].
  ///
  /// This feature is only available for users who have Retail Search enabled.
  /// Please submit a form [here](https://cloud.google.com/contact) to contact
  /// cloud sales if you are interested in using Retail Search.
  ///
  /// @param inventory  Required. The inventory information to update. The
  /// allowable fields to
  ///  update are:
  ///  * [Product.price_info][google.cloud.retail.v2.Product.price_info]
  ///  * [Product.availability][google.cloud.retail.v2.Product.availability]
  ///  * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
  ///  * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
  ///  The updated inventory fields must be specified in
  ///  [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask].
  ///  If [SetInventoryRequest.inventory.name][] is empty or invalid, an
  ///  INVALID_ARGUMENT error is returned.
  ///  If the caller does not have permission to update the
  ///  [Product][google.cloud.retail.v2.Product] named in
  ///  [Product.name][google.cloud.retail.v2.Product.name], regardless of
  ///  whether or not it exists, a PERMISSION_DENIED error is returned. If the
  ///  [Product][google.cloud.retail.v2.Product] to update does not have
  ///  existing inventory information, the provided inventory information will
  ///  be inserted. If the [Product][google.cloud.retail.v2.Product] to update
  ///  has existing inventory information, the provided inventory information
  ///  will be merged while respecting the last update time for each inventory
  ///  field, using the provided or default value for
  ///  [SetInventoryRequest.set_time][google.cloud.retail.v2.SetInventoryRequest.set_time].
  ///  The last update time is recorded for the following inventory fields:
  ///  * [Product.price_info][google.cloud.retail.v2.Product.price_info]
  ///  * [Product.availability][google.cloud.retail.v2.Product.availability]
  ///  * [Product.available_quantity][google.cloud.retail.v2.Product.available_quantity]
  ///  * [Product.fulfillment_info][google.cloud.retail.v2.Product.fulfillment_info]
  ///  If a full overwrite of inventory information while ignoring timestamps is
  ///  needed, [UpdateProduct][] should be invoked instead.
  /// @param set_mask  Indicates which inventory fields in the provided
  ///  [Product][google.cloud.retail.v2.Product] to update. If not set or set
  ///  with empty paths, all inventory fields will be updated. If an unsupported
  ///  or unknown field is provided, an INVALID_ARGUMENT error is returned and
  ///  the entire update will be ignored.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::SetInventoryResponse,google/cloud/retail/v2/product_service.proto#L493}
  ///
  /// [google.cloud.retail.v2.SetInventoryRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L425}
  /// [google.cloud.retail.v2.SetInventoryResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L493}
  ///
  future<StatusOr<google::cloud::retail::v2::SetInventoryResponse>>
  SetInventory(google::cloud::retail::v2::Product const& inventory,
               google::protobuf::FieldMask const& set_mask,
               Options options = {});

  ///
  /// Updates inventory information for a
  /// [Product][google.cloud.retail.v2.Product] while respecting the last update
  /// timestamps of each inventory field.
  ///
  /// This process is asynchronous and does not require the
  /// [Product][google.cloud.retail.v2.Product] to exist before updating
  /// fulfillment information. If the request is valid, the update will be
  /// enqueued and processed downstream. As a consequence, when a response is
  /// returned, updates are not immediately manifested in the
  /// [Product][google.cloud.retail.v2.Product] queried by
  /// [GetProduct][google.cloud.retail.v2.ProductService.GetProduct] or
  /// [ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
  ///
  /// When inventory is updated with
  /// [CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct] and
  /// [UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct], the
  /// specified inventory field value(s) will overwrite any existing value(s)
  /// while ignoring the last update time for this field. Furthermore, the last
  /// update time for the specified inventory fields will be overwritten to the
  /// time of the
  /// [CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct] or
  /// [UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct]
  /// request.
  ///
  /// If no inventory fields are set in
  /// [CreateProductRequest.product][google.cloud.retail.v2.CreateProductRequest.product],
  /// then any pre-existing inventory information for this product will be used.
  ///
  /// If no inventory fields are set in [UpdateProductRequest.set_mask][],
  /// then any existing inventory information will be preserved.
  ///
  /// Pre-existing inventory information can only be updated with
  /// [SetInventory][google.cloud.retail.v2.ProductService.SetInventory],
  /// [AddFulfillmentPlaces][google.cloud.retail.v2.ProductService.AddFulfillmentPlaces],
  /// and
  /// [RemoveFulfillmentPlaces][google.cloud.retail.v2.ProductService.RemoveFulfillmentPlaces].
  ///
  /// This feature is only available for users who have Retail Search enabled.
  /// Please submit a form [here](https://cloud.google.com/contact) to contact
  /// cloud sales if you are interested in using Retail Search.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::SetInventoryRequest,google/cloud/retail/v2/product_service.proto#L425}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::SetInventoryResponse,google/cloud/retail/v2/product_service.proto#L493}
  ///
  /// [google.cloud.retail.v2.SetInventoryRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L425}
  /// [google.cloud.retail.v2.SetInventoryResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L493}
  ///
  future<StatusOr<google::cloud::retail::v2::SetInventoryResponse>>
  SetInventory(google::cloud::retail::v2::SetInventoryRequest const& request,
               Options options = {});

  ///
  /// Incrementally adds place IDs to
  /// [Product.fulfillment_info.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids].
  ///
  /// This process is asynchronous and does not require the
  /// [Product][google.cloud.retail.v2.Product] to exist before updating
  /// fulfillment information. If the request is valid, the update will be
  /// enqueued and processed downstream. As a consequence, when a response is
  /// returned, the added place IDs are not immediately manifested in the
  /// [Product][google.cloud.retail.v2.Product] queried by
  /// [GetProduct][google.cloud.retail.v2.ProductService.GetProduct] or
  /// [ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
  ///
  /// This feature is only available for users who have Retail Search enabled.
  /// Please submit a form [here](https://cloud.google.com/contact) to contact
  /// cloud sales if you are interested in using Retail Search.
  ///
  /// @param product  Required. Full resource name of
  /// [Product][google.cloud.retail.v2.Product],
  ///  such as
  ///  `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
  ///  If the caller does not have permission to access the
  ///  [Product][google.cloud.retail.v2.Product], regardless of whether or not
  ///  it exists, a PERMISSION_DENIED error is returned.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::AddFulfillmentPlacesResponse,google/cloud/retail/v2/product_service.proto#L569}
  ///
  /// [google.cloud.retail.v2.AddFulfillmentPlacesRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L496}
  /// [google.cloud.retail.v2.AddFulfillmentPlacesResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L569}
  ///
  future<StatusOr<google::cloud::retail::v2::AddFulfillmentPlacesResponse>>
  AddFulfillmentPlaces(std::string const& product, Options options = {});

  ///
  /// Incrementally adds place IDs to
  /// [Product.fulfillment_info.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids].
  ///
  /// This process is asynchronous and does not require the
  /// [Product][google.cloud.retail.v2.Product] to exist before updating
  /// fulfillment information. If the request is valid, the update will be
  /// enqueued and processed downstream. As a consequence, when a response is
  /// returned, the added place IDs are not immediately manifested in the
  /// [Product][google.cloud.retail.v2.Product] queried by
  /// [GetProduct][google.cloud.retail.v2.ProductService.GetProduct] or
  /// [ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
  ///
  /// This feature is only available for users who have Retail Search enabled.
  /// Please submit a form [here](https://cloud.google.com/contact) to contact
  /// cloud sales if you are interested in using Retail Search.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::AddFulfillmentPlacesRequest,google/cloud/retail/v2/product_service.proto#L496}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::AddFulfillmentPlacesResponse,google/cloud/retail/v2/product_service.proto#L569}
  ///
  /// [google.cloud.retail.v2.AddFulfillmentPlacesRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L496}
  /// [google.cloud.retail.v2.AddFulfillmentPlacesResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L569}
  ///
  future<StatusOr<google::cloud::retail::v2::AddFulfillmentPlacesResponse>>
  AddFulfillmentPlaces(
      google::cloud::retail::v2::AddFulfillmentPlacesRequest const& request,
      Options options = {});

  ///
  /// Incrementally removes place IDs from a
  /// [Product.fulfillment_info.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids].
  ///
  /// This process is asynchronous and does not require the
  /// [Product][google.cloud.retail.v2.Product] to exist before updating
  /// fulfillment information. If the request is valid, the update will be
  /// enqueued and processed downstream. As a consequence, when a response is
  /// returned, the removed place IDs are not immediately manifested in the
  /// [Product][google.cloud.retail.v2.Product] queried by
  /// [GetProduct][google.cloud.retail.v2.ProductService.GetProduct] or
  /// [ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
  ///
  /// This feature is only available for users who have Retail Search enabled.
  /// Please submit a form [here](https://cloud.google.com/contact) to contact
  /// cloud sales if you are interested in using Retail Search.
  ///
  /// @param product  Required. Full resource name of
  /// [Product][google.cloud.retail.v2.Product],
  ///  such as
  ///  `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`.
  ///  If the caller does not have permission to access the
  ///  [Product][google.cloud.retail.v2.Product], regardless of whether or not
  ///  it exists, a PERMISSION_DENIED error is returned.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::RemoveFulfillmentPlacesResponse,google/cloud/retail/v2/product_service.proto#L640}
  ///
  /// [google.cloud.retail.v2.RemoveFulfillmentPlacesRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L572}
  /// [google.cloud.retail.v2.RemoveFulfillmentPlacesResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L640}
  ///
  future<StatusOr<google::cloud::retail::v2::RemoveFulfillmentPlacesResponse>>
  RemoveFulfillmentPlaces(std::string const& product, Options options = {});

  ///
  /// Incrementally removes place IDs from a
  /// [Product.fulfillment_info.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids].
  ///
  /// This process is asynchronous and does not require the
  /// [Product][google.cloud.retail.v2.Product] to exist before updating
  /// fulfillment information. If the request is valid, the update will be
  /// enqueued and processed downstream. As a consequence, when a response is
  /// returned, the removed place IDs are not immediately manifested in the
  /// [Product][google.cloud.retail.v2.Product] queried by
  /// [GetProduct][google.cloud.retail.v2.ProductService.GetProduct] or
  /// [ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
  ///
  /// This feature is only available for users who have Retail Search enabled.
  /// Please submit a form [here](https://cloud.google.com/contact) to contact
  /// cloud sales if you are interested in using Retail Search.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::retail::v2::RemoveFulfillmentPlacesRequest,google/cloud/retail/v2/product_service.proto#L572}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::retail::v2::RemoveFulfillmentPlacesResponse,google/cloud/retail/v2/product_service.proto#L640}
  ///
  /// [google.cloud.retail.v2.RemoveFulfillmentPlacesRequest]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L572}
  /// [google.cloud.retail.v2.RemoveFulfillmentPlacesResponse]:
  /// @googleapis_reference_link{google/cloud/retail/v2/product_service.proto#L640}
  ///
  future<StatusOr<google::cloud::retail::v2::RemoveFulfillmentPlacesResponse>>
  RemoveFulfillmentPlaces(
      google::cloud::retail::v2::RemoveFulfillmentPlacesRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<ProductServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_PRODUCT_CLIENT_H
