// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/user_event_service.proto

#include "google/cloud/retail/internal/user_event_connection_impl.h"
#include "google/cloud/retail/internal/user_event_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

UserEventServiceConnectionImpl::UserEventServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<retail_internal::UserEventServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), retail_internal::UserEventServiceDefaultOptions(
                                  UserEventServiceConnection::options()))) {}

StatusOr<google::cloud::retail::v2::UserEvent>
UserEventServiceConnectionImpl::WriteUserEvent(
    google::cloud::retail::v2::WriteUserEventRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->WriteUserEvent(request),
      [this](grpc::ClientContext& context,
             google::cloud::retail::v2::WriteUserEventRequest const& request) {
        return stub_->WriteUserEvent(context, request);
      },
      request, __func__);
}

StatusOr<google::api::HttpBody>
UserEventServiceConnectionImpl::CollectUserEvent(
    google::cloud::retail::v2::CollectUserEventRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CollectUserEvent(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::retail::v2::CollectUserEventRequest const& request) {
        return stub_->CollectUserEvent(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::retail::v2::PurgeUserEventsResponse>>
UserEventServiceConnectionImpl::PurgeUserEvents(
    google::cloud::retail::v2::PurgeUserEventsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::retail::v2::PurgeUserEventsResponse>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::retail::v2::PurgeUserEventsRequest const& request) {
        return stub->AsyncPurgeUserEvents(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::retail::v2::PurgeUserEventsResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->PurgeUserEvents(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::retail::v2::ImportUserEventsResponse>>
UserEventServiceConnectionImpl::ImportUserEvents(
    google::cloud::retail::v2::ImportUserEventsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::retail::v2::ImportUserEventsResponse>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::retail::v2::ImportUserEventsRequest const& request) {
        return stub->AsyncImportUserEvents(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::retail::v2::ImportUserEventsResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ImportUserEvents(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::retail::v2::RejoinUserEventsResponse>>
UserEventServiceConnectionImpl::RejoinUserEvents(
    google::cloud::retail::v2::RejoinUserEventsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::retail::v2::RejoinUserEventsResponse>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::retail::v2::RejoinUserEventsRequest const& request) {
        return stub->AsyncRejoinUserEvents(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::retail::v2::RejoinUserEventsResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->RejoinUserEvents(request), polling_policy(),
      __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_internal
}  // namespace cloud
}  // namespace google
