// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#include "google/cloud/retail/internal/catalog_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/retail/v2/catalog_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace retail_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CatalogServiceStub::~CatalogServiceStub() = default;

StatusOr<google::cloud::retail::v2::ListCatalogsResponse>
DefaultCatalogServiceStub::ListCatalogs(
    grpc::ClientContext& client_context,
    google::cloud::retail::v2::ListCatalogsRequest const& request) {
  google::cloud::retail::v2::ListCatalogsResponse response;
  auto status = grpc_stub_->ListCatalogs(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::retail::v2::Catalog>
DefaultCatalogServiceStub::UpdateCatalog(
    grpc::ClientContext& client_context,
    google::cloud::retail::v2::UpdateCatalogRequest const& request) {
  google::cloud::retail::v2::Catalog response;
  auto status = grpc_stub_->UpdateCatalog(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultCatalogServiceStub::SetDefaultBranch(
    grpc::ClientContext& client_context,
    google::cloud::retail::v2::SetDefaultBranchRequest const& request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->SetDefaultBranch(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
DefaultCatalogServiceStub::GetDefaultBranch(
    grpc::ClientContext& client_context,
    google::cloud::retail::v2::GetDefaultBranchRequest const& request) {
  google::cloud::retail::v2::GetDefaultBranchResponse response;
  auto status =
      grpc_stub_->GetDefaultBranch(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_internal
}  // namespace cloud
}  // namespace google
